/***************************************************************************
                          gatelist.cpp  -  description
                             -------------------
    begin                : Sun Jan 18 2004
    copyright            : (C) 2004 by Oliver Kern
    email                : oliver.kern@physik.tu-darmstadt.de
 ***************************************************************************/

#include "gatelist.h"

 double gatelist::modphase(double f){
   while(f>dpi) f-=2.*dpi;
   while(f<=-dpi) f+=2.*dpi;
   return f;
 }
 double gatelist::modphase(double f, int exp){
   //calculate f*2^exp  (mod 2Pi)
   if (exp>0)
   for(int m=1; m<=exp; m++){ f*=2.; f=modphase(f); }
   else { f/=(1<<(-exp)); f=modphase(f); }
   return f;
 }

 //Quantum Fourier Transform, needs n*(n+1)/2 quantum gates, relabels don't count
 void gatelist::qft(){
  for(int j=(qubits-1); j>=0; j--) {
   for(int i=(qubits-1); i>j; i--) ccphase(j,i, dpi/(1<<(i-j)) );
   hada(j);
  }
  for(int i=0; i<(qubits/2); i++) relabel(i,qubits-1-i);
 }
 //Inverse QFT
 void gatelist::backqft(){
  for(int j=(qubits-1); j>=0; j--) {
   for(int i=(qubits-1); i>j; i--) ccphase(j,i, -dpi/(1<<(i-j)) );
   hada(j);
  }
  for(int i=0; i<(qubits/2); i++) relabel(i,qubits-1-i);
 }


//**** sawtooth map *************
void gatelist::sawtooth(double K, double T){
 //number of gates = 2*( n(n-1)/2 + n ) + 2*( n(n+1)/2 ) = 2n^2 + 2n
 double k=K/T;
 qft();

 //th=2pi n/N
 //exp(i k/2*(th-pi)^2 )=exp(i k/2*th^2 )...
 for(int i=1; i<qubits; i++)
   for(int j=0; j<i; j++) ccphase(i,j, modphase(k*dpi*dpi, i+j-2*qubits+2) );
 for(int i=0; i<qubits; i++)
    cphase(i, modphase(                      //...exp(-i k pi*th )...
      modphase(k*dpi*dpi, 2*i-1-2*qubits+2)+modphase(-k*dpi*dpi, i+1-qubits)  ));
 //...exp(ik/2 pi^2):  phase( k/2.*dpi*dpi );

 backqft();

 //exp(-i T/2*n^2 )...
 for(int i=1; i<qubits; i++)
   for(int j=0; j<i; j++) ccphase(i,j, modphase(-T, i+j) );
 for(int i=0; i<qubits; i++) cphase(i, modphase(-T, 2*i-1) );
}


void gatelist::cccphase(int c1, int c2, int c3, double p){
  p=modphase(p);
  if (fabs(p)>1e-6) {
     cnot(c2,c3);
     ccphase(c1,c2, -p/2.);
     cnot(c2,c3);
     ccphase(c1,c2, p/2.);
     ccphase(c1,c3, p/2.);
  } else std::cout << "skipped CCCP gate " << p << '\n';
}

//***** tent map *************
void gatelist::tent(double K, double T){
 double k=K/T;
 qft();

 for(int i=1; i<qubits-1; i++)
   for(int j=0; j<i; j++) {
    cccphase(j,i,qubits-1, modphase(-k*dpi*dpi, j+i-2*qubits+3) );
              ccphase(j,i, modphase( k*dpi*dpi, j+i-2*qubits+2) );
   }
 for(int j=0; j<qubits-1; j++) {
    ccphase(j,qubits-1, modphase(-k*dpi*dpi*(modphase(1., j-qubits+1)-1.), j-qubits+1) );
              cphase(j, modphase( k*dpi*dpi*(modphase(1., j-qubits+1)-1.), j-qubits  ) );
   }

 backqft();

 //exp(-i T/2*n^2 )
 for(int i=1; i<qubits; i++)
   for(int j=0; j<i; j++) ccphase(i,j, modphase(-T, i+j) );
 for(int i=0; i<qubits; i++) cphase(i, modphase(-T, 2*i-1) );
}



