/***************************************************************************
 *   Copyright (C) 2004-2005 by Oliver Kern                                *
 *   oliver.kern@physik.tu-darmstadt.de                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <cstdlib>

#include "qregbase.h"

// you have to adjust the path:
std::string path="/home/user/Files/";


int main(){
 std::string filename;
 std::fstream datei;

 char ch='W'; g05zaf_(ch);//choose NAG random number generator
 g05ccf_();//init with random seed
 double dummy=0.; for (int s=0; s<10; s++) double us=g05caf_(dummy);//draw some numbers


 //Two quantum registers, one for imperfect and one for ideal calculation:
 int qubits=10;
 int dim=1<<qubits;
 qregbase reg(qubits, path);
 qregbase ideal_reg(qubits, path);

 //Choose Quantum Algorithm and Parameters:
 double K=1.7;
 double T=2.*dpi/dim;
       reg.gl.tent(K,T);
 ideal_reg.gl.tent(K,T);

 //Calculate one map iteration to count the gates
 //(relabels are no gates and are not counted) :
 ideal_reg.sim_g(1);
 int gates=ideal_reg.gcount;
 std::cout << "Gates counted : " << gates << '\n';
 std::cout << "Gates calc.   : " << 4.5*qubits*qubits-5.5*qubits+4. << '\n';
 // The actual number of quantum gates is smaller than expected
 // because some of the phase gates aquire phase zero (due to the choise
 // of K and T) and are skipped.
 ideal_reg.reset();

 //Convert the gates of the quantum algorithm into
 //Hamiltonian X,Z, and XX gates, e.g. Not=exp(-i X/2 Pi)
 reg.convgl();
 //Calculate one map iteration to count the gates:
 reg.sim_parec_h(1,-1);
 std::cout << "HGates : " << reg.gcount << '\n';
 reg.gcount=0;
 reg.zeit=0.;


 //Set the initial state:
 //Coherent state in the chaotic regime :
//       reg.coherentp(5.35/(2.*dpi)*dim,0);
// ideal_reg.coherentp(5.35/(2.*dpi)*dim,0);
 //Coherent state in the integrable regime :
       reg.coherentp(dim/8,0);
 ideal_reg.coherentp(dim/8,0);


 //***** Choose at random some static imperfections and save them in a file:
 //double eps=5e-6;
 //reg.stconfinit(2.*sqrt(3.)*eps, 2.*sqrt(3.)*eps);//das erste wird gleich halbiert
 //reg.stconfwrite("config");
 //***** Load static imperfections from file:
 reg.stconfread("config");
 reg.stconfshow();


 int its=5000;//number of map iterations to calculate
 double* fid=new double[its+1];

 filename=path+"fidelity.txt";
 datei.open(filename.c_str(), std::ios::out);
 if (!datei) { std::cout << "error"; std::exit(1); }
 datei.close();

 for(int i=1; i<=its; i++){
    //Calculate one ideal iteration:
    ideal_reg.sim_g(1);

    //PAREC with random Pauli-Sequence every x Hamiltonian quantum gates:
    //reg.sim_parec_h(1, x);   x<0 means without random corrections.
    //e.g. use x>2115 to do apply one PAREC sequence before each map iteration,
    //because one 10qubit tent map iteration consists of 2115 Hamiltonian gates.
    reg.sim_parec_h(1, -1);

    //Calculate the Husimidistribution after 3000 iterations:
    if (i==3000) {
     husimi h("husimi-3000", &reg);
     h.calc();
     h.savedbl();
    }

    fid[i]=log( fidelity(&reg, &ideal_reg) );
    std::cout << i << " Fidelity : " << fid[i] << ' ' <<  fidelity(&reg, &ideal_reg) << '\n';
    std::cout << reg.gcount << ' ' << reg.zeit << '\n';

    //write log(fidelity) in a file:
    datei.open(filename.c_str(), std::ios::out|std::ios::app);
    datei << fid[i] << '\n';
    datei.close();
 }
 delete [] fid;


 return EXIT_SUCCESS;
}
