/***************************************************************************
                          qregbase.cpp  -  description
                             -------------------
    begin                : Mon Jan 19 2004
    copyright            : (C) 2004 by Oliver Kern
    email                : oliver.kern@physik.tu-darmstadt.de
 ***************************************************************************/
#include "qregbase.h"



//*******************************************************************************************************
 permuta::permuta(int qubits_):qubits(qubits_){
  p=new int[qubits];
  clear();
 }
 permuta::~permuta(){
  delete [] p;
 }
 void permuta::clear(){
  for (int i=0; i<qubits; i++) p[i]=i;
 }
 int permuta::trueregint(int r){
  int t=0;
  for (int i=0; i<qubits; i++) {
   int b= ((r&(1<<p[i]))>0);
   t|=b*(1<<i);
  }
  return t;
 }
 int permuta::falseregint(int r){
  int t=0;
  for (int i=0; i<qubits; i++) {
   int b= ((r&(1<<i))>0);
   t|=b*(1<<p[i]);
  }
  return t;
 }
 void permuta::relabel(int tar1, int tar2){
  int tmp=p[tar1];
  p[tar1]=p[tar2];
  p[tar2]=tmp;
 }
 void permuta::relabelph(int tar1, int tar2){
  int a=-1;
  for(int i=0; i<qubits; i++) if (p[i]==tar1) a=i;
  int b=-1;
  for(int i=0; i<qubits; i++) if (p[i]==tar2) b=i;
  int tmp=p[a];
  p[a]=p[b];
  p[b]=tmp;
 }
//*******************************************************************************************************


//*******************************************************************************************************
 void hamiltonlist::clear(){
  dt=0.;
  relabel=false;
  eccb[0]=-1; eccb[1]=-1;
  h.clear();
 }
//*******************************************************************************************************


//*******************************************************************************************************
 void thverlauf::conv(gateentry g, thverlauf::iterator p){
  // converts a quantum gate g into a set of Hamiltonian gates and inserts before p
  hamiltonlist hl;
  double deins=0.;

   switch(g.g){
    // ein qubit gates
    case gnot:hl.h.push_back( hamilton(hx, 1., g.t) );
              hl.h.push_back( hamilton(h1, -1. ) );//phase(dpi/2.);
              hl.dt=dpi/2.;
              insert(p, hl);
              break;

    case ghada:hl.h.push_back( hamilton(hz, 1., g.t) );
               hl.dt=dpi/4.;
               insert(p, hl);
               hl.clear();
               hl.h.push_back( hamilton(hx, 1., g.t) );
               hl.dt=dpi/4.;
               insert(p, hl);
               hl.clear();
               hl.h.push_back( hamilton(hz, 1., g.t) );
               hl.h.push_back( hamilton(h1, -2.) );//phase(dpi/2.);
               hl.dt=dpi/4.;
               insert(p, hl);
               break;

    case gcphase:if (g.p>0.) deins=1.; else deins=-1.;
                 hl.h.push_back( hamilton(hz, deins, g.c1) );
                 hl.h.push_back( hamilton(h1, -deins) );//phase((*gl.listpos).p/2.);
                 hl.dt=fabs(g.p)/2.;
                 insert(p, hl);
                 break;

    // zwei qubit gates
    case gcnot:hl.h.push_back( hamilton(hx, 1., g.c1) );
                hl.dt=dpi/4.;
                insert(p, hl);
                hl.clear();
                 hl.h.push_back( hamilton(hz, 1., g.c1) );
                 hl.dt=dpi/4.;
                 insert(p, hl);
                 hl.clear();
                hl.h.push_back( hamilton(hxx, -1., g.t, g.c1) );
                hl.h.push_back( hamilton(h1, -1.) );
                hl.dt=dpi/4.;
                insert(p, hl);
                hl.clear();
                 hl.h.push_back( hamilton(hz, 1., g.c1) );
                 hl.dt=dpi/4.;
                 insert(p, hl);
                 hl.clear();
                hl.h.push_back( hamilton(hx, 1., g.t) );
                hl.dt=dpi/4.;
                //insert(p, hl);
                //hl.clear();
                 hl.h.push_back( hamilton(hx, 1., g.c1) );
                 hl.dt=dpi/4.;
                 insert(p, hl);
                 hl.clear();
                hl.h.push_back( hamilton(hz, -1., g.c1) );
                hl.dt=dpi/4.;
                insert(p, hl);
                break;

    case gccphase:double k=(dpi+g.p/2.)/2.;
                   hl.h.push_back( hamilton(hx, 1., g.c2) );
                   hl.dt=dpi/4.;
                   //insert(p, hl);
                   //hl.clear();
                    hl.h.push_back( hamilton(hx, 1., g.c1) );
                    hl.dt=dpi/4.;
                    insert(p, hl);
                    hl.clear();
                   hl.h.push_back( hamilton(hz, 1., g.c2) );
                   hl.dt=dpi/4.;
                   //insert(p, hl);
                   //hl.clear();
                    hl.h.push_back( hamilton(hz, 1., g.c1) );
                    hl.dt=dpi/4.;
                    insert(p, hl);
                    hl.clear();

                   if (g.p>0.) deins=1.; else deins=-1.;
                   hl.h.push_back( hamilton(hxx, -deins, g.c1, g.c2) );
                   hl.h.push_back( hamilton(h1, -deins) );
                   hl.dt=fabs(g.p/4.);
                   insert(p, hl);
                   hl.clear();

                   hl.h.push_back( hamilton(hz, 1., g.c2) );
                   hl.dt=dpi/4.;
                   //insert(p, hl);
                   //hl.clear();
                    hl.h.push_back( hamilton(hz, 1., g.c1) );
                    hl.dt=dpi/4.;
                    insert(p, hl);
                    hl.clear();
                   hl.h.push_back( hamilton(hx, 1., g.c2) );
                   hl.dt=dpi/4.;
                   //insert(p, hl);
                   //hl.clear();
                    hl.h.push_back( hamilton(hx, 1., g.c1) );
                    hl.dt=dpi/4.;
                    insert(p, hl);
                    hl.clear();
                   hl.h.push_back( hamilton(hz, 1., g.c2) );
                   hl.dt=k;
                   //insert(p, hl);
                   //hl.clear();
                    hl.h.push_back( hamilton(hz, 1., g.c1) );
                    hl.dt=k;
                    insert(p, hl);
                  break;
    case grelabel:hl.relabel=true;
                  hl.eccb[0]=g.c1;
                  hl.eccb[1]=g.c2;
                  insert(p, hl);
                  break;
    default:std::cout << "Warning can't convert ...\n"; break;
   }
 }
//*******************************************************************************************************




//*************** The quantum register object ***********************************************************

 void qregbase::parecon(){
  for(int i=0; i<qubits; i++) {
       switch(parec[i]){case 0: break;
                         case 1:do_ph_not(i); break;
                         case 2:do_ph_sy(i); break;
                         case 3:do_ph_sz(i); break; }
  }
 }

 void qregbase::convgl(){
  //convert a quantum algorithm, i.e. a list of quantum gates
  //into a list of Hamiltonian quantum gates
   hverlauf.clear();
   gl.start();
   while (gl.listpos!=gl.end()) {
    hverlauf.conv( (*gl.listpos), hverlauf.end() );
    gl.listpos++;
   }
 }

 inline void qregbase::neuput(int i, complex d){ neureg[i]=d; }
 inline void qregbase::neuadd(int i, complex d){ neureg[i]+=d; }
 inline void qregbase::neumin(int i, complex d){ neureg[i]-=d; }
 inline void qregbase::neumul(int i, complex d){ neureg[i]*=d; }

 inline void qregbase::neu(){
  neureg=new complex[dim];
  for (int s=0; s<dim; s++) neureg[s]=0.;
 }
 inline void qregbase::storeneu(){
  delete [] reg;
  reg=neureg;
 }


qregbase::qregbase(int qubits_, std::string path_):
  do_coup(false),
  dim(1<<qubits_), qubits(qubits_),
  pos(qubits_),
  zeit(0.), path(path_),
  gcount(0),
  gl(qubits_)  {

  parec=new int[qubits];
  for(int i=0; i<qubits; i++) parec[i]=0;
  reg=new complex[dim];
  clearreg();

  delta=new double[qubits];
  coupij=new double[qubits*(qubits-1)/2];
  for (int i=0; i<qubits; i++) delta[i]=0.;
  for (int i=0; i<(qubits*(qubits-1)/2); i++) coupij[i]=0.;
 }
 qregbase::~qregbase(){
  delete [] parec;
  delete [] reg;
  delete [] delta;
  delete [] coupij;
 }

 void qregbase::reset(){
  pos.clear();
  clearreg();
  gcount=0;
  zeit=0.;
  for (int i=0; i<qubits; i++) parec[i]=0;
 }

 void qregbase::coherentp(int qpos, int ppos){
  //construct coherent state at (qpos,ppos)
  double n=pow(2./dim, 0.25);
  for(int i=0; i<dim; i++){
   int dn=i-ppos+dim/2; if (dn<0) dn+=dim; dn=dn%dim; dn-=dim/2;
   reg[i]=n*exp( complex(-dn*dn*dpi/dim, -i*2.*dpi/dim*qpos) );
  }
  //normiere();
 }


 void qregbase::docoupapprox(double p){
  //approximate time evolution according to the coupling Hamiltonian
  double f=fabs(p)/dpi;

  for(int i=0; i<qubits; i++) do_ph_rz(i, -delta[i]*f);
  int n=0;
  for (int i=1; i<qubits; i++) for (int j=0; j<i; j++) {
    //if (coupij[n]!=0.) do_ph_rxx(j,i, coupij[n]*f);//xx
    if (coupij[n]!=0.) do_ph_rxyz(j,i, coupij[n]*f);// 1/2(xx+yy+zz)
    n++;
  }
  zeit+=f;
 }


 void qregbase::sim_parec_g(int its, int ngef){
  parecon();//switch on the actual pauli sequence
  for (int z=1; z<=its; z++) {
    gl.start();
    while (gl.listpos!=gl.end()) {

     if ((*gl.listpos).g==grelabel) dogate( (*gl.listpos) ); else {
         if (ngef>0)//ngef<=0  ==>  don't do randomization
         if (gcount%ngef==0) {//****new random pauli sequence
            for(int i=0; i<qubits; i++) {
             int v1=0; int v2=3;
             int rn=g05dyf_(v1,v2);
             switch(rn){
              case 0:break;
              case 1:do_ph_not(i);  break;
              case 2:do_ph_sy(i);   break;
              case 3:do_ph_sz(i);   break;
             }
             parec[i]^=rn;
            }
            docoupapprox(dpi);
         }//****
         gateentry g=(*gl.listpos);
         int q[3]; q[0]=-1; q[1]=-1; q[2]=-1;
         switch(g.g){
          // ein qubit gates
          case gnot:   q[0]=pos.p[g.t];  break;
          case ghada:  q[0]=pos.p[g.t];  break;
          case gcphase:q[0]=pos.p[g.c1]; break;
          // zwei qubit gates
          case gcnot:    q[0]=pos.p[g.t];  q[1]=pos.p[g.c1]; break;
          case gccphase: q[0]=pos.p[g.c1]; q[1]=pos.p[g.c2]; break;
          case gswap:    q[0]=pos.p[g.c1]; q[1]=pos.p[g.c2]; break;
          // eigentlich keine gates
          case gphase:   break;
          default: std::cout << "not in sim_parec_g \n"; break;
         }

         for(int k=0; k<=2; k++){
            if (q[k]>=0)
            switch(parec[ q[k] ]){
             case 1:do_ph_not(q[k]); break;
             case 2:do_ph_sy(q[k]);  break;
             case 3:do_ph_sz(q[k]);  break;
            }
         }
         dogate( (*gl.listpos) );
         for(int k=0; k<=2; k++){
            if (q[k]>=0)
            switch(parec[ q[k] ]){
             case 1:do_ph_not(q[k]); break;
             case 2:do_ph_sy(q[k]);  break;
             case 3:do_ph_sz(q[k]);  break;
            }
         }
         gcount++;
         docoupapprox(dpi);
     }
     gl.listpos++;
    }//while loop
  }//iterations loop
  parecon();//switch off the actual pauli sequence, for computation of the fidelity
 }


 void qregbase::sim_parec_h(int its, int ngef){
  parecon();//switch on the actual pauli sequence

  for (int z=1; z<=its; z++) {
     hverlaufpos=hverlauf.begin();
     while (hverlaufpos!=hverlauf.end()) {

        if ((*hverlaufpos).relabel) {
          pos.relabel( (*hverlaufpos).eccb[0], (*hverlaufpos).eccb[1] );
        } else {
         if (ngef>0)//ngef<=0  ==>  don't do randomization
         if (gcount%ngef==0) {//****new random pauli sequence
            for(int i=0; i<qubits; i++) {
             int v1=0; int v2=3;
             int rn=g05dyf_(v1,v2);
             switch(rn){
              case 0:break;
              case 1:do_ph_rx(i, dpi/2.);
                     docoupapprox(dpi/2.);
                     break;
              case 2:do_ph_rz(i, -dpi/4.);
                     docoupapprox(dpi/4.);
                     do_ph_rx(i, dpi/2.);
                     docoupapprox(dpi/2.);
                     do_ph_rz(i, dpi/4.);
                     docoupapprox(dpi/4.);
                     break;
              case 3:do_ph_rz(i, dpi/2.);
                     docoupapprox(dpi/2.);
                     break;
             }
             parec[i]^=rn;
            }
         }//****

         for(int i=0; i<(*hverlaufpos).h.size(); i++){
          double ph=(*hverlaufpos).dt*(*hverlaufpos).h[i].fak;
          int qb0,qb1;
          switch( (*hverlaufpos).h[i].typ ){
            case  h1:do_phase(-ph); break;
            case  hx:qb0=pos.p[(*hverlaufpos).h[i].qb[0]];
                      if ((parec[qb0]!=0)&&(parec[qb0]!=1)) ph*=-1.;
                      do_ph_rx( qb0, ph);
                      break;
            case  hz:qb0=pos.p[(*hverlaufpos).h[i].qb[0]];
                      if ((parec[qb0]!=0)&&(parec[qb0]!=3)) ph*=-1.;
                      do_ph_rz( qb0, ph);
                      break;
            case hxx:qb0=pos.p[(*hverlaufpos).h[i].qb[0]];
                      qb1=pos.p[(*hverlaufpos).h[i].qb[1]];
                      if (parec[qb0]!=parec[qb1]) { int a,b;
                       if (parec[qb0]<parec[qb1]) { a=parec[qb0]; b=parec[qb1]; }
                                                   else { b=parec[qb0]; a=parec[qb1]; }
                       if (!( ((a==0)&&(b==1))||((a==2)&&(b==3)) )) ph*=-1.;
                      }
                      do_ph_rxx( qb0, qb1, ph);
                      break;
            case hzz:qb0=pos.p[(*hverlaufpos).h[i].qb[0]];
                      qb1=pos.p[(*hverlaufpos).h[i].qb[1]];
                      if (parec[qb0]!=parec[qb1]) { int a,b;
                       if (parec[qb0]<parec[qb1]) { a=parec[qb0]; b=parec[qb1]; } 
                                                   else { b=parec[qb0]; a=parec[qb1]; }
                       if (!( ((a==0)&&(b==3))||((a==1)&&(b==2)) )) ph*=-1.;
                      }
                      do_ph_rzz( qb0, qb1, ph);
                      break;
            default:std::cout << "not in sim_parec_h \n"; break;
          }
         }
         gcount++;
         docoupapprox( (*hverlaufpos).dt );
        }
        hverlaufpos++;
     }//while loop
  }//iterations loop
  parecon();//switch off the actual pauli sequence, for computation of the fidelity
 }


 //calculate its iterations of a quantum algorithm stored in gl
 void qregbase::sim_g(int its){
  for(int z=1; z<=its; z++) {
     gl.start();
     while (gl.listpos!=gl.end()) {
        if ((*gl.listpos).g==grelabel) dogate( (*gl.listpos) );
        else {
         dogate( (*gl.listpos) );
         gcount++;
         //possibly perform imperfections:
         if (do_coup) docoupapprox(dpi);
        }
        gl.listpos++;
     }//while loop
  }//iterations loop
 }


 void qregbase::stconfwrite(std::string fn){
  std::string filename=path+fn+".dbl";
  std::fstream datei;
  datei.open( filename.c_str(), std::ios::out | std::ios::binary);
  datei.write((char*)delta, qubits*sizeof(double) );
  datei.write((char*)coupij, qubits*(qubits-1)/2*sizeof(double) );
  datei.close();
 }
 void qregbase::stconfread(std::string fn){
  std::string filename=path+fn+".dbl";
  std::fstream datei;
  datei.open( filename.c_str(), std::ios::in | std::ios::binary);
  datei.read((char*)delta, qubits*sizeof(double) );
  datei.read((char*)coupij, qubits*(qubits-1)/2*sizeof(double) );
  datei.close();
  do_coup=true;
 }
 void qregbase::stconfinit(double d, double J){
  double bis=d/2.;
  double von=-bis;
  int ifail=0;
  g05faf_(von, bis, qubits, delta, ifail);//uniform a..b array
  bis=J;
  von=-bis;
  int n=qubits*(qubits-1)/2;
  g05faf_(von, bis, n, coupij, ifail);//uniform a..b array
  n=0;
  for (int i=1; i<qubits; i++)
   for (int j=0; j<i; j++) {
      //*** no couplings :
      //coupij[n]=0.;
      //*** linear chain :
      if (j!=(i-1)) coupij[n]=0.;
      n++;
   }
  do_coup=true;
  stconfshow();
 }
 void qregbase::stconfshow(){
  std::cout << "Static imperfections strenghts :   ( do_coup=" << do_coup << " )\n";
  for (int i=0; i<qubits; i++) std::cout << "delta i " << i << " : " << delta[i] << '\n';
  int n=0;
  for(int i=1; i<qubits; i++)
   for(int j=0; j<i; j++) {
      std::cout << "coup i " << i << " j " << j << " : " << coupij[n] << '\n';
      n++;
   }
 }

 double qregbase::betragsq(){
  double n=0.;
  for (int s=0; s<dim; s++) n+=norm( reg[s] );
  return n;
 }

 void qregbase::normiere(){
  double bq=sqrt(betragsq());
  for (int s=0; s<dim; s++) reg[s]/=bq;
 }


 void qregbase::do_ph_not(int tar){//sigma_x
  pcomplex nreg=new complex[dim];
  int t=1<<tar;
  for (int s=0; s<dim; s++) nreg[s^t]=reg[s];
  delete [] reg;
  reg=nreg;
 }
 void qregbase::do_ph_sy(int tar){//sigmay
  pcomplex nreg=new complex[dim];
  int t=1<<tar;
  for (int s=0; s<dim; s++) if (s&t) nreg[s^t]=reg[s]*complex(0.,-1.); else nreg[s^t]=reg[s]*complex(0.,1.);
  delete [] reg;
  reg=nreg;
 }
 void qregbase::do_ph_sz(int tar){//sigmaz
  int t=1<<tar;
  for (int s=0; s<dim; s++) if (s&t) reg[s]*=complex(-1.,0.);
 }


 void qregbase::do_ph_rxx(int cont1, int cont2, double p){//exp( - I XX t )
  int s;
  pcomplex nreg=new complex[dim];
  int c1=1<<cont1;
  int c2=1<<cont2;
  complex cp=complex( cos(p),0. );
  complex sp=complex( 0.,sin(p) );
  for (s=0; s<dim; s++) nreg[s]=0.;
  for (s=0; s<dim; s++) { nreg[s]+=cp*reg[s]; nreg[s^(c1|c2)]-=sp*reg[s]; }
  delete [] reg;
  reg=nreg;
 }
 void qregbase::do_ph_rzz(int cont1, int cont2, double p){//exp( - I ZZ t )
  int s;
  int c1=1<<cont1;
  int c2=1<<cont2;
  bool b1,b2;
  complex pe=complex(cos(p),sin(p));
  complex ne=complex(cos(p),-sin(p));
  for (s=0; s<dim; s++) {
   b1=s&c1;
   b2=s&c2;
   if (b1!=b2) reg[s]*=pe; else reg[s]*=ne;
  }
 }
 void qregbase::do_ph_rxyz(int cont1, int cont2, double p){//exp(-I t 1/2(xx yy zz))
  int s;
  pcomplex nreg=new complex[dim];
  int c1=1<<cont1;
  int c2=1<<cont2;
  complex en=complex( cos(p/2.),-sin(p/2.) );
  complex cp=complex( cos(p),0. )*complex( cos(p/2.),sin(p/2.) );
  complex sp=complex( 0.,-sin(p) )*complex( cos(p/2.),sin(p/2.) );
  for (s=0; s<dim; s++) nreg[s]=0.;
  for (s=0; s<dim; s++)
   if ( bool(s&c1)==bool(s&c2) ) nreg[s]+=en*reg[s];
                          else { nreg[s]+=cp*reg[s]; nreg[s^(c1|c2)]+=sp*reg[s]; }
  delete [] reg;
  reg=nreg;
 }

 void qregbase::do_ph_rx(int cont1, double p){//exp(-I X p)
  pcomplex nreg=new complex[dim];
  complex cp=complex( cos(p),0. );
  complex sp=complex( 0.,sin(p) );
  for(int s=0; s<dim; s++) nreg[s]=0.;
  int c=1<<cont1;
  for(int s=0; s<dim; s++) { nreg[s^c]-=sp*reg[s]; nreg[s]+=cp*reg[s]; }
  delete [] reg;
  reg=nreg;
 }
 void qregbase::do_ph_ry(int cont1, double p){//exp(-I Y p)
  pcomplex nreg=new complex[dim];
  complex cp=complex( cos(p),0. );
  complex sp=complex( sin(p),0. );
  for(int s=0; s<dim; s++) nreg[s]=0.;
  int c=1<<cont1;
  for(int s=0; s<dim; s++) { if (s&c) nreg[s^c]-=sp*reg[s]; else nreg[s^c]+=sp*reg[s];
                              nreg[s]+=cp*reg[s]; }
  delete [] reg;
  reg=nreg;
 }
 void qregbase::do_ph_rz(int cont1, double p){//exp(-I Z p)
  int c1=1<<cont1;
  complex pe=complex(cos(p),sin(p));
  complex ne=complex(cos(p),-sin(p));
  for(int s=0; s<dim; s++)
    if (s&c1) reg[s]*=pe; else reg[s]*=ne;
 }


 //**** one qubit quantum gates ********
 void qregbase::do_not(int tar){
  neu();
  int t=1<<pos.p[tar];
  for (int s=0; s<dim; s++) neuadd(s^t, reg[s]);
  storeneu();
 }
 void qregbase::do_hada(int tar){
  neu();
  int t=1<<pos.p[tar];
  for (int s=0; s<dim; s++)
   if (s&t) { neuadd(s^t, reg[s]/sqrt(2.)); neumin(s, reg[s]/sqrt(2.)); } else
            { neuadd(s^t, reg[s]/sqrt(2.)); neuadd(s, reg[s]/sqrt(2.)); }
  storeneu();
 }
 void qregbase::do_cphase(int cont1, double p){
  int c1=1<<pos.p[cont1];
  for (int s=0; s<dim; s++)
   if (s&c1) reg[s]*=complex(cos(p),sin(p));
 }
 //**** two qubit quantum gates ********
 void qregbase::do_cnot(int tar, int cont){
  neu();
  int c=1<<pos.p[cont];
  int t=1<<pos.p[tar];
  for (int s=0; s<dim; s++) {
   if (s&c) neuadd(s^t, reg[s]); else neuadd(s, reg[s]);
  }
  storeneu();
 }
 void qregbase::do_swap(int tar1, int tar2){
  int t1=1<<pos.p[tar1];
  int t2=1<<pos.p[tar2];
  neu();
  for(int s=0; s<dim; s++) {
   int ns=s;
   bool b1= ( (s&t1) > 0);
   bool b2= ( (s&t2) > 0);
   if (b1) ns|=t2; else ns&=(~t2);
   if (b2) ns|=t1; else ns&=(~t1);
   neuput(ns, reg[s] );
  }
  storeneu();
 }
 void qregbase::do_ccphase(int cont1, int cont2, double p){
  int c1=1<<pos.p[cont1];
  int c2=1<<pos.p[cont2];
  for (int s=0; s<dim; s++)
   if ( (s&c1) && (s&c2) ) reg[s]*=complex(cos(p),sin(p));
 }
 //**** three qubit quantum gates *******
 void qregbase::do_ccnot(int tar, int cont1, int cont2){
  neu();
  int c2=1<<pos.p[cont2];
  int c=1<<pos.p[cont1];
  int t=1<<pos.p[tar];
  for (int s=0; s<dim; s++)
   if ((s&c) && (s&c2)) neuadd(s^t, reg[s]); else neuadd(s, reg[s]);
  storeneu();
 }
 //**** global phase *******************
 void qregbase::do_phase(double p){
  complex ep=complex(cos(p),sin(p));
  for (int s=0; s<dim; s++) reg[s]*=ep;
 }


 void qregbase::dogate(gateentry g){
  //perform the quantum gate g
  switch(g.g){
   //one qubit gates
   case gnot:do_not( g.t );  break;
   case ghada:do_hada( g.t );  break;
   case gcphase:do_cphase( g.c1, g.p );  break;
   //two qubit gates
   case gcnot:do_cnot( g.t, g.c1 );  break;
   case gccphase:do_ccphase( g.c1, g.c2, g.p );  break;
   case gswap:do_swap( g.c1, g.c2 );  break;
   //no quantum gates
   case gphase:do_phase( g.p );  break;
   case grelabel:pos.relabel( g.c1, g.c2 );  break;
   default: std::cout <<"ACHTUNG Dogate doesn't found gentry \n"; break;
  }
 }

//*******************************************************************************************************


//********* Calculate the fidelity between the two quantum states r1 and r2 *****************************
 double fidelity(qregbase* r1, qregbase* r2){
  if ((*r1).dim==(*r2).dim) {
   complex f=0.;
   for(int s=0; s<(*r1).dim; s++)
      f+=(*r1).reg[ (*r1).pos.falseregint(s) ]*conj((*r2).reg[ (*r2).pos.falseregint(s) ]);
   return norm(f);
  } else return -1.;
 }
//*******************************************************************************************************


//*****************  The Husimi distribution object *****************************************************
 husimi::husimi(std::string name_, qregbase* qr_): qr(qr_), name(name_), dim((*qr_).dim) {
  if (dim<=(1<<9)) pdim=dim; else pdim=(1<<9);
  hus=new double[pdim*pdim];
  clear();
 };

 husimi::~husimi(){
  delete [] hus;
 };

 void husimi::clear(){ for(int i=0; i<pdim; i++) for(int j=0; j<pdim; j++) hus[i*pdim+j]=0.; };

 void husimi::calc(){
  //calculate the husimi distribution as picture with dimension pdim*pdim
  //in dim*dim*qubits*qubits steps ( N^2 * (log N)^2 steps )
  int cg=dim/pdim;
  double zdn=pow(2./dim, 0.25);
  for(int p=0; p<dim; p++){
    qregbase psi( (*qr).qubits, "" );
    for(int m=0; m<dim; m++) {
      int dn=m-p+dim/2; if (dn<0) dn+=dim; dn=dn%dim; dn-=dim/2;
      double tmp=dn*dn;
      psi.reg[m]=exp(-dpi*tmp/dim)*(*qr).reg[(*qr).pos.falseregint(m)]*zdn;
    }
    psi.gl.qft();
    psi.sim_g(1);
    for(int q=0; q<dim; q++) hus[p/cg*pdim + q/cg]+=norm( psi.reg[ psi.pos.falseregint(q) ] );
  }
 }

 void husimi::savedbl(){
  std::string filename=(*qr).path+name+".dbl";
  std::fstream datei;
  datei.open( filename.c_str(), std::ios::out | std::ios::binary);
  if (!datei) { std::cout << "error"; std::exit(1); }
  datei.write((char*)hus, (pdim*pdim)*sizeof(double) );
  datei.close();
  std::cout << "Wrote Husimi " << filename << '\n';
 }
//*******************************************************************************************************

