/***************************************************************************
                          gatelist.h  -  description
                             -------------------
    begin                : Sun Jan 18 2004
    copyright            : (C) 2004 by Oliver Kern
    email                : oliver.kern@physik.tu-darmstadt.de
 ***************************************************************************/

#ifndef _Gatelist_H
#define _Gatelist_H

#include <list>
#include <cmath>
#include <iostream>

const double dpi=3.1415926535897932385;

enum gate { // single qubit gates
            gnot, ghada, gcphase,
            // two qubit gates
            gcnot, gccphase, gswap,
             //no gates
            gphase, grelabel
           };
struct gateentry{
 gate g;
 short int t,c1,c2,c3;
 double p;
};

typedef std::list< gateentry > tgatelist;

class gatelist:public tgatelist{
 private:
 gateentry e;
 int qubits;
 double modphase(double f);
 double modphase(double f, int exp);
 public:
 tgatelist::iterator listpos;

 gatelist(int qubits_):tgatelist(), qubits(qubits_) {}
 void start(){ listpos=begin(); }

 void relabel(int t1, int t2){ e.g=grelabel; e.c1=t1; e.c2=t2; push_back(e); }
 void swap(int t1, int t2){ e.g=gswap; e.c1=t1; e.c2=t2; push_back(e); }
 void nt(int tar){ e.g=gnot; e.t=tar; push_back(e); }
 void cnot(int tar, int c1){ e.g=gcnot; e.t=tar; e.c1=c1; push_back(e); }
 void hada(int tar){ e.g=ghada; e.t=tar; push_back(e); }
 void cccphase(int c1, int c2, int c3, double p);
 void ccphase(int c1, int c2, double p){ e.g=gccphase; e.c1=c1; e.c2=c2; e.p=modphase(p);
   if (fabs(e.p)>1e-6)
   push_back(e); else std::cout << "skipped CCP gate " << p << '\n';
 }
 void cphase(int c1, double p){ e.g=gcphase; e.c1=c1; e.p=modphase(p);
   if (fabs(e.p)>1e-6)
   push_back(e); else std::cout << "skipped CP gate " << p << '\n';
 }
 void phase(double p){ e.g=gphase; e.p=p; push_back(e); }

 void qft();
 void backqft();

 void tent(double K, double T);
 void sawtooth(double K, double T);
};

#endif
