/***************************************************************************
                          qregbase.h  -  description
                             -------------------
    begin                : Mon Jan 19 2004
    copyright            : (C) 2004 by Oliver Kern
    email                : oliver.kern@physik.tu-darmstadt.de
 ***************************************************************************/

#ifndef _QregBase_H
#define _QregBase_H

#include <vector>
#include <queue>
#include <complex>
#include <fstream>
#include <sstream>

#include "gatelist.h"


typedef std::complex<double> complex;
typedef complex* pcomplex;

extern "C" void g05zaf_(char &c_);//W (new and better) or O (old)
extern "C" void g05cbf_(int &i_);//init with seed i
extern "C" void g05ccf_();//init with random seed

extern "C" double g05caf_(double &x_); //uniform 0..1 //dummy parameter x
extern "C" int g05dyf_(int &a_, int &b_);//uniform a..b int
extern "C" double g05daf_(double &a_, double &b_);//uniform a..b
extern "C" double g05faf_(double &a_, double &b_, int &n_, double x_[], int &ifail_);//uniform a..b array



enum htype {//single qubit Hamiltonians
            hx, hz,
            //two qubit Hamiltonians
            hxx, hzz,
            //1 Hamiltonian for global phase
            h1
           };
struct hamilton{
 htype typ;
 int qb[2];
 double fak;
 hamilton( htype t, double f, int qb1, int qb2):typ(t),fak(f) { qb[0]=qb1; qb[1]=qb2; }
 hamilton( htype t, double f, int qb1):typ(t),fak(f) { qb[0]=qb1; }
 hamilton( htype t, double f):typ(t),fak(f) {}
};
struct hamiltonlist{//ein eintrag in hverlauf
 double dt;
 std::vector< hamilton > h;

 bool relabel;
 int eccb[2];
 hamiltonlist():dt(0.), relabel(false) { eccb[0]=-1; eccb[1]=-1; }
 void clear();
};

typedef std::list< hamiltonlist > Tlistofhamlitonlist;
class thverlauf:public Tlistofhamlitonlist{
public:
 void conv(gateentry g, thverlauf::iterator p);//converts g in hamiltonlist, insert before p
};




class permuta{
private:
 int qubits;
protected:
public:
 int* p;
 permuta(int qubits_);
 ~permuta();
 void clear();
 int trueregint(int r);
 int falseregint(int r);
 void relabel(int tar1, int tar2);
 void relabelph(int tar1, int tar2);
};


class qregbase{
private:
 bool do_coup;
 pcomplex neureg;

 int dim, qubits;
 permuta pos;

 void neu();
 void storeneu();
 void neuput(int i, complex d);
 void neuadd(int i, complex d);
 void neumin(int i, complex d);
 void neumul(int i, complex d);

public:
 pcomplex reg;

 double* delta;
 double* coupij;

 double zeit;

 int* parec;
 void parecon();

 std::string path;

 void convgl();
 thverlauf hverlauf;
 thverlauf::iterator hverlaufpos;

 int gcount;
 gatelist gl;

 qregbase(int qubits_, std::string path_);
 ~qregbase();

 void reset();
 inline void clearreg(){ for(int s=0; s<dim; s++) reg[s]=0.; };

 void coherentp(int qn, int pn);
 double betragsq();
 void normiere();

 void sim_g(int its);
 void sim_parec_h(int its, int ngef);
 void sim_parec_g(int its, int ngef);

 void dogate(gateentry g);
 void docoupapprox(double p);

 void stconfwrite(std::string fn);
 void stconfread(std::string fn);
 void stconfinit(double d, double J);
 void stconfshow();

 void do_ph_not(int tar); //sx
 void do_ph_sy(int tar);
 void do_ph_sz(int tar);

 void do_ph_rxx(int cont1, int cont2, double p);
 void do_ph_rzz(int cont1, int cont2, double p);
 void do_ph_rxyz(int cont1, int cont2, double p);
 void do_ph_rx(int cont1, double p);
 void do_ph_ry(int cont1, double p);
 void do_ph_rz(int cont1, double p);

 //one qubit gates
 void do_not(int tar);
 void do_hada(int tar);
 void do_cphase(int cont1, double p);
 //two qubit gates
 void do_cnot(int tar, int cont);
 void do_ccphase(int cont1, int cont2, double p);
 void do_swap(int tar1, int tar2);
 //three qubit gates
 void do_ccnot(int tar, int cont1, int cont2);
 //global phase
 void do_phase(double p);

 friend class husimi;
 friend double fidelity(qregbase* r1, qregbase* r2);
};


class husimi{
private:
 double* hus;
 qregbase* qr;
 std::string name;
 int dim, pdim;
public:
 husimi(std::string name_, qregbase* qr_);
 ~husimi();
 void clear();
 void calc();
 void savedbl();
};

#endif
