//
//  2-dimensional lattice 
//
//  
//
//
//  last modified 19/07/2004

#ifndef _Q_LATTICE_H_
#define _Q_LATTICE_H_

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <complex>
#include <string.h>
#include "qubits.h"
using std::complex;

class Lattice
{ public:
  double * a,*b,A,B,*rM;
  int Nx,Ny,Nq;
  int *indMap,*indMapR;  
  
  
  Lattice(int Lx, int Ly, double Alpha, double Beta)
  { Nx=Lx; Ny=Ly; Nq=Nx*Ny;
    A=Alpha; B=Beta;
    a=(double*)calloc(Nq,sizeof(double));
    b=(double*)calloc(Nq*2,sizeof(double));
    indMap =(int*)calloc(Nq,sizeof(int));
    indMapR=(int*)calloc(Nq,sizeof(int));
    rM=(double*)calloc(Nq,sizeof(double));
    for(int i=0; i<Nq; i++)
    { a[i]=2*(drand48()-0.5)*A;
      b[2*i]=2*(drand48()-0.5)*B;
      b[2*i+1]=2*(drand48()-0.5)*B;
      indMap[i]=i; indMapR[i]=i;                  // identical map
    }; 
  };
  
  Lattice(Lattice& L)
  { Nx=L.Nx; Ny=L.Ny; Nq=Nx*Ny;
    a=(double*)calloc(Nq,sizeof(double));
    b=(double*)calloc(Nq*2,sizeof(double));
    for(int i=0; i<Nq; i++)
    { a[i]=L.a[i];
      b[2*i]=L.b[2*i];
      b[2*i+1]=L.b[2*i+1];
    }; 
  };
  
  ~Lattice(){ free(a); free(b); };

// periodically continued  
int iQBit(int x, int y) { while(x>=Nx) x-=Nx; while(y>=Ny) y-=Ny; return x+Nx*y; };

Lattice& operator = (Lattice& L)
  { Nx=L.Nx; Ny=L.Ny; Nq=Nx*Ny;
    a=(double*)calloc(Nq,sizeof(double));
    b=(double*)calloc(Nq*2,sizeof(double));
    for(int i=0; i<Nq; i++)
    { a[i]=L.a[i];
      b[2*i]=L.b[2*i];
      b[2*i+1]=L.b[2*i+1];
    }; 
    return *this;
  };

void Rand()
  {
    for(int i=0; i<Nq; i++)
    { a[i]=2*(drand48()-0.5)*A;
      b[2*i]=2*(drand48()-0.5)*B;
      b[2*i+1]=2*(drand48()-0.5)*B;
    }; 
  }
   
void RandMap()
  {
    for(int i=0; i<Nq; i++) rM[i]=drand48();
    double prevMin=0.;
    for(int i=0; i<Nq; i++)
    {  int jm=-1;
       double Rmin=2.;
       for(int j=0; j<Nq; j++) if( rM[j]>prevMin && rM[j]<Rmin) { Rmin=rM[j]; jm=j;}
//       printf("jm=%d\n",jm);
       indMap[i]  =jm; 
       indMapR[jm]=i;
       prevMin=Rmin;
    }; 
    for(int i=0; i<Nq; i++) 
       if(indMapR[indMap[i]]!=i) 
         { printf("RandMap Failed");
           abort();
         }  
  }

void Perturb(QBitsWaveFunction& QR) 
	{ int n=QR.n;
	  for(int i=0; i<n; i++) QR.RotateQBit(indMap[i],2*a[i]); // SigmaZ interaction with external field
	  for(int i=0;i<n;i++) QR.WH_tr(i); // Hadamard rotation SigmaX -> Sigma Z
          int iq;
	  for(int ix=0; ix<Nx; ix++) 
	     for(int iy=0; iy<Ny; iy++) 
	     { iq=iQBit(ix,iy);
	       QR.InteractQBits(indMap[iq],indMap[iQBit(ix+1,iy)],b[2*iq]);
	       QR.InteractQBits(indMap[iq],indMap[iQBit(ix,iy+1)],b[2*iq+1]);
	     }
	  for(int i=0;i<n;i++) QR.WH_tr(i); // Hadamard rotation SigmaX -> Sigma Z
	};
   
};
#endif
