#include "qc.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Grover algoritm with static noise --- test of algoritms


int main()
{
   int Nx=3,Ny=4,Nq=Nx*Ny-1,ver,cRead;
   double Alpha=0.000, Beta=0.026;
   long extSeed;
   FILE* Dat=fopen("data","r");

for(int Jdat=0; Jdat<100; Jdat++)
{
// First we define a lattice
//                          Nq -- number of useful qubits: must be >=6 !!! 
   if((cRead=fscanf(Dat," %d %lg %lg %ld\n",&ver,&Alpha,&Beta,&extSeed))==EOF) return 0;
   printf("ver=%d   Alpha=%g  Beta=%g  seed=%ld %d\n",ver,Alpha,Beta,extSeed, cRead);

// Next we calculate the number of states
   int Nst=1<<Nq;
   printf("Number of useful qubits=%d\n",Nq);
// Next create wave function vector  
   QBitsWaveFunction A0(Nq+1,"WF_0"),A(Nq+1,"WF");

//---- state to be searched for
   int Is=77;

//---- Now estimate the number of states needed to reach maximum 
   double omega=asin(2*sqrt(Nst-1.)/Nst),Tw=2*3.14159/omega;
   printf("Number of steps needed to reach maximum=%f\n",Tw/4);
   int Nstep=int(5*Tw);
   double* W =new double[Nstep];
   double* Ws =new double[Nstep];
   double* W1 =new double[Nstep];
   double* W4_L =new double[Nstep];
   double* W4_R =new double[Nstep];
   double* W1t=new double[Nstep];
   double* F =new double[Nstep];
   complex<double>* Cw1  =new complex<double>[Nstep];
   complex<double>* Cw2  =new complex<double>[Nstep];
   double* Cws =new double[Nstep];
   for(int i=0; i<Nstep;i++) { W[i]=0; Ws[i]=0; W1[i]=0; W4_L[i]=0; W4_R[i]=0; W1t[i]=0; F[i]=0; Cw1[i]=0; Cw2[i]=0;Cws[i]=0;};


   long seed=time(0); 
   seed=extSeed;
   srand48(seed);
   printf("random seed value=%ld\n",seed);


//======================== Here we start a loop over nR noise realization
int nR=1;

for(int iR=0; iR<nR; iR++)
{
  Lattice L(Nx,Ny,Alpha,Beta);
  PertCount=0;
// --- initial state preparation
  A.SetZero();
  A<<WH(0,Nq-1); A0=A;

  for(int it=0; it<Nstep;it++)
  {

//===========  Oracle (primitive)
     A0.wf[Is]*=-1.; A0.wf[Is+Nst]*=-1.;
     A.wf[Is]*=-1.;  A.wf[Is+Nst]*=-1.;

//===========  Diffusion operator D=H*R*H ====================== 

     for(int i=0;i<Nq;i++) A0 << WH(i);
     for(int i=0;i<Nq;i++) A  << WH(i) << Pert(&L);
//-----------  here we implement the matrix R --------------------

     for(int i=0;i<Nq;i++) A0 << X(i);
     for(int i=0;i<Nq;i++) A  << X(i) << Pert(&L);
     A0 << WH(Nq-1);
     A  << WH(Nq-1) << Pert(&L);
   
     int n=Nq+1,n2=(Nq+1)>>1;
     for(int L1=1; L1<=2; L1++)
     {
       for(int L2=1; L2<=2; L2++)
       {
         for(int i=n-1;i>=n-n2+2; i--) A0<<CCnot(n2-n+i,i-1,i);
         for(int i=n-1;i>=n-n2+2; i--) A <<CCnot(n2-n+i,i-1,i) << Pert(&L);
         A0<<CCnot(0,1,n-n2+1);
         A <<CCnot(0,1,n-n2+1) << Pert(&L);
         for(int i=n-n2+2;i<=n-2; i++) A0<<CCnot(n2-n+i,i-1,i);
         for(int i=n-n2+2;i<=n-2; i++) A <<CCnot(n2-n+i,i-1,i) << Pert(&L);
       }   
       for(int L2=1; L2<=2; L2++)
       {
         A0<<CCnot(0,n2,n-2);
         A <<CCnot(0,n2,n-2) << Pert(&L);
         for(int i=0;i<=n-n2-5; i++) A0<<CCnot(n2+1+i,i+1,i);
         for(int i=0;i<=n-n2-5; i++) A <<CCnot(n2+1+i,i+1,i) << Pert(&L);
         A0<<CCnot(n-3,n-1,n-n2-4);
         A <<CCnot(n-3,n-1,n-n2-4) << Pert(&L);
         for(int i=n-n2-5;i>=0; i--) A0<<CCnot(n2+1+i,i+1,i);
         for(int i=n-n2-5;i>=0; i--) A <<CCnot(n2+1+i,i+1,i) << Pert(&L);
       }   
     }   
     A0 << WH(Nq-1);
     A  << WH(Nq-1) << Pert(&L);
     for(int i=0;i<Nq;i++) A0 << X(i);
     for(int i=0;i<Nq;i++) A  << X(i) << Pert(&L);
//--------------------- matrix R end ----------------------
     for(int i=0;i<Nq;i++) A0 << WH(i);
     for(int i=0;i<Nq;i++) A  << WH(i) << Pert(&L);
//===================== end of D - diffusion operator -----

     W[it]+=sqr(abs(A.wf[Is]))+sqr(abs(A.wf[Is+Nst]));
     complex<double> ws0=0,ws1=0,iunity=complex<double>(0,1); 
     for(int i=0;i<Nst;i++) if(i!=Is) { ws0+=(A.wf[i]); ws1+=(A.wf[i+Nst]);}; 
     Ws[it]+=(sqr(abs(ws0))+sqr(abs(ws1)))/(Nst-1.);
     FILE* fi=fopen('out.dat',"w");
     fprintf(fi,"it=%d, Ws=%f Alpha=%f Beta=%f \n",it,Ws[it],Alpha,Beta);
     fclose(fi);
  };
  printf("Realization = %d with %d insertions of QBits interactions\n",iR,PertCount);
};
   char Fout[16];
   sprintf(Fout,"A%dB%dv1.dat",int(Alpha*10000.1),int(Beta*10000.1));
   FILE* f=fopen(Fout,"w");
   fprintf(f,"#  A=%6.4f  B=%6.4f  nR=%d seed=%ld\n",Alpha,Beta,nR,seed);
   fprintf(f,"#  step   probability  fidelity  W1 W1_up W4_L W4_R omega As(Omega) Ws\n");
   double stb=0;
   for(int i=0; i<Nstep; i++) 
      fprintf(f,"%d   %f %f   %f %f  %f %f   %f %f   %f\n",
                i,W[i]/nR,stb,stb,stb,stb,stb,stb,stb,Ws[i]/nR);
   fclose(f);


}
  return 0;
}
