#include "qAlgebra.h"
#include "qJump.h"
#include "qPlot.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Grover algoritm with decoherence -- "quantum jumps"

int main()
{
   int Nx=3,Ny=4,Nq=Nx*Ny-1,cRead;
   double Alpha=0.000, Beta=0.026, GammaDt=0;
   long extSeed;
   int nR=3;
   int Is=1773;
   FILE* Dat=fopen("data","r");

for(int Jdat=0; Jdat<100; Jdat++)
{
// First we define a lattice
//                          Nq -- number of useful qubits: must be >=6 !!! 
   if((cRead=fscanf(Dat," %d %d %lg %lg %lg %ld\n",&nR,&Is,&GammaDt,&Alpha,&Beta,&extSeed))==EOF) return 0;
   printf("nR=%d Is=%d Gamma*dt=%g Alpha=%g  Beta=%g  seed=%ld %d\n",nR,Is,GammaDt,Alpha,Beta,extSeed, cRead);

// Next we calculate the number of states
   int Nst=1<<Nq;
   printf("Number of useful qubits=%d\n",Nq);
// Next create wave function vector  
   QBitsWaveFunction A0(Nq+1,"WF_0"),A(Nq+1,"WF");

//---- state to be searched for

//---- Now estimate the number of states needed to reach maximum 
   double omega=asin(2*sqrt(Nst-1.)/Nst),Tw=2*3.14159/omega;
   printf("Number of steps needed to reach maximum=%f\n",Tw/4);
   int Nstep=int(Tw/4)+1;
//   Nstep=1;

   double* W =new double[Nstep];
   double* Ws =new double[Nstep];
   double* Wtot =new double[Nstep];
   double* F =new double[Nstep];
   for(int i=0; i<Nstep;i++) { W[i]=0; Ws[i]=0; Wtot[i]=0; F[i]=0; };
   Husimi Hus[Nstep];
   for(int it=0; it<Nstep; it++) Hus[it].initHusimi(A);

   long seed=time(0); 
   seed=extSeed;
   srand48(seed);
   printf("random seed value=%ld\n",seed);


//======================== Here we start a loop over nR noise realization
static double sNjump=0,sNbranch=0,swNbranch=0; 

for(int iR=0; iR<nR; iR++)
{
  Lattice L(Nx,Ny,Alpha,Beta);
  PertCount=0;
// --- initial state preparation
  A.SetZero();
//  Husimi hus0; hus0.initHusimi(A); hus0<<A; hus0.printHusData("Aq0.dat");

  
  A<<WH(0,Nq-1); A0=A;
//  Husimi hus1; hus1.initHusimi(A); hus1<<A; hus1.printHusData("Ap0.dat");
//  return 0;

  Njump=0; Nbranch=0; wNbranch=0; 

  for(int it=0; it<Nstep;it++)
  {
//     L.RandMap();
//===========  Oracle (primitive)
     A0.wf[Is]*=-1.; A0.wf[Is+Nst]*=-1.;
     A.wf[Is]*=-1.;  A.wf[Is+Nst]*=-1.;

//===========  Diffusion operator D=H*R*H ====================== 

     for(int i=0;i<Nq;i++) A0 << WH(i);
     for(int i=0;i<Nq;i++) A  << WH(i) << Jump(GammaDt);
//-----------  here we implement the matrix R --------------------

     for(int i=0;i<Nq;i++) A0 << X(i);
     for(int i=0;i<Nq;i++) A  << X(i) << Jump(GammaDt);
     A0 << WH(Nq-1);
     A  << WH(Nq-1) << Jump(GammaDt);
   
     int n=Nq+1,n2=(Nq+1)>>1;
     for(int L1=1; L1<=2; L1++)
     {
       for(int L2=1; L2<=2; L2++)
       {
         for(int i=n-1;i>=n-n2+2; i--) A0<<CCnot(n2-n+i,i-1,i);
         for(int i=n-1;i>=n-n2+2; i--) A <<CCnot(n2-n+i,i-1,i) << Jump(GammaDt);
         A0<<CCnot(0,1,n-n2+1);
         A <<CCnot(0,1,n-n2+1) << Jump(GammaDt);
         for(int i=n-n2+2;i<=n-2; i++) A0<<CCnot(n2-n+i,i-1,i);
         for(int i=n-n2+2;i<=n-2; i++) A <<CCnot(n2-n+i,i-1,i) << Jump(GammaDt);
       }   
       for(int L2=1; L2<=2; L2++)
       {
         A0<<CCnot(0,n2,n-2);
         A <<CCnot(0,n2,n-2) << Jump(GammaDt);
         for(int i=0;i<=n-n2-5; i++) A0<<CCnot(n2+1+i,i+1,i);
         for(int i=0;i<=n-n2-5; i++) A <<CCnot(n2+1+i,i+1,i) << Jump(GammaDt);
         A0<<CCnot(n-3,n-1,n-n2-4);
         A <<CCnot(n-3,n-1,n-n2-4) << Jump(GammaDt);
         for(int i=n-n2-5;i>=0; i--) A0<<CCnot(n2+1+i,i+1,i);
         for(int i=n-n2-5;i>=0; i--) A <<CCnot(n2+1+i,i+1,i) << Jump(GammaDt);
       }   
     }   
     A0 << WH(Nq-1);
     A  << WH(Nq-1) << Jump(GammaDt);
     for(int i=0;i<Nq;i++) A0 << X(i);
     for(int i=0;i<Nq;i++) A  << X(i) << Jump(GammaDt);
//--------------------- matrix R end ----------------------
     for(int i=0;i<Nq;i++) A0 << WH(i);
     for(int i=0;i<Nq;i++) A  << WH(i) << Jump(GammaDt);
//===================== end of D - diffusion operator -----
     double Wit=abs(A*A);

     Wtot[it]+=Wit;
     W[it]+=(sqr(abs(A.wf[Is]))+sqr(abs(A.wf[Is+Nst])))/Wit; // probability of searched state
     complex<double> ws0=0,ws1=0,iunity=complex<double>(0,1); 
     for(int i=0;i<Nst;i++) if(i!=Is) { ws0+=(A.wf[i]); ws1+=(A.wf[i+Nst]);}; 
     F[it]+=sqr(abs(A*A0))/Wit;
     
     Ws[it]+=((sqr(abs(ws0))+sqr(abs(ws1)))/(Nst-1.))/Wit;
     Hus[it]<<A;
  };
  printf("Realization = %d with %d insertions of QBits interactions\n",iR,PertCount);
  printf("#  Njumps=%8.5f av Branch No=%8.5f av wBranch No=%8.5f \n",Njump,Nbranch,wNbranch);
  sNjump+=Njump; sNbranch+=Nbranch; swNbranch+=wNbranch; 

};

   char Fout[16];
   sprintf(Fout,"G%dB%dav.dat",int(GammaDt*100000.1),int(Beta*10000.1));
   FILE* f=fopen(Fout,"w");
   fprintf(f,"#  Gamma*dt=%g A=%6.4f  B=%6.4f  nR=%d Is=%d seed=%ld\n",GammaDt,Alpha,Beta,nR,Is,seed);
   fprintf(f,"#  Njumps=%8.5f av Branch No=%8.5f av wBranch No=%8.5f \n",sNjump/nR,sNbranch/nR,swNbranch/nR);
   fprintf(f,"#  step t/t_G probability  fidelity  Ws Wtot \n");
   for(int i=0; i<Nstep; i++) 
      { double Wt=Wtot[i]/nR,nr=nR; 
        fprintf(f,"%d %f  %f  %f  %f  %14.11f\n", i,4*i/Tw,W[i]/nr,F[i]/nr,Ws[i]/nr,Wt);
      }
   fclose(f);
   for(int it=0; it<Nstep; it++)
   { double Xn[50];
     sprintf(Fout,"it%d.dat",it+1);
     (Hus[it]).printHusData(Fout);
     Xn[it]=(Hus[it]).xNorm;
//     sprintf(Fout,"itg%d.dat",it+1);
//     (Hus[it]).HusDataXYZ(Fout);
   };
   FILE* f=fopen("Anorm.dat","w");
   for(int i=0; i<Nstep; i++) 
      { double Wt=Wtot[i]/nR,nr=nR; 
        fprintf(f,"%d %f  %f \n", i,Xn[i]/nR,Xn/nr/Wt);
      }
   fclose(f);
   
};
  return 0;
}
