<TeXmacs|1.0.5.12>

<style|article>

<\body>
  <doc-data|<doc-title|Transparent simulation of quantum
  algorithms>|<doc-subtitle|(Object-oriented
  approach)>|<doc-author-data|<author-name|A.A. Pomeransky, D.L. Shepelyansky
  and O.V. Zhirov>>>

  <\abstract>
    We present a software library which allows to implement quantum computing
    algorithm in very transparent manner.\ 
  </abstract>

  <section|Introdiction.>

  \;

  Currently quantum computers are on the very beginning of practical
  implementation. A few qubits created in laboratories are still unsufficient
  to study quantum algorithms in practice and gain their advantage. A great
  challenge is going on search of a physical system which is efficient in
  practical quibits implementation, with unavoidable imperfections and
  external perturbations caused by enviroment. In parallel, a great activity
  is devoted to understanding the stability of quantum algorithms to
  imperfections of quantum qubits and gates, and to practical testing of them
  on common classical computers.

  Each of quantum algorithm consists of many elements, a linear sequence of
  quantum gates, acting on quantum register. Each gate can be implemented by
  a piece of simple code, but the pattern of all these gates can be rather
  complicated, and final program can be huge. This makes the writing of such
  programs and their debugging be a difficult process, as well as their
  modifications can in principle break the code completely.\ 

  In fact, the object-oriented approach, which was proposed in programming
  about twenty years ago, can provide a very effective and elegant solution
  of this problem. Below we start with a paradigm, which turns the problem
  into a child game with bricks. In this way we introduce a set of
  ``bricks'', the objects which implement the quantum register and quantum
  gates. These objects are written in C++ programming language, and can be
  easily extended. As a result, the most code is incapsulated in these
  objects; the rules of composition of these objects are very simple, and the
  final code, the implementation of quantum algorithm becomes very compact
  and pictural.

  <section|The paradigm.>\ 

  The heart of \ quantum computer is a <em|quantum register>, which is
  prepared in some quantum state <with|mode|math|<left|\|>X<right|rangle>>.
  The process of quantum computation consist of a chain (sometimes very
  long!) of unitary transformations <with|mode|math|U> applied to this
  register subsequently:

  <\equation>
    <left|\|>X<rprime|'><right|rangle>=U<rsub|M>U<rsub|M-1>\<ldots\>U<rsub|2>U<rsub|1><left|\|>X<right|rangle>
  </equation>

  and final state <with|mode|math|<left|\|>X<rprime|'><right|rangle>>
  contains some results of calculations. For a qubit the quantum state is
  described by two-component complex array\ 

  <\equation*>
    <mid|\|>q<right|rangle>=<left|(><tabular|<tformat|<table|<row|<cell|a<rsub|1>>>|<row|<cell|a<rsub|2>>>>>><right|)>
  </equation*>

  while the quantum state of the register containing
  <with|mode|math|n<rsub|q>> qubits, which is a direct product of qubit
  quantum states\ 

  <\equation*>
    <left|\|>X<right|rangle>=<mid|\|>q<rsub|1><right|rangle>\<otimes\><mid|\|>q<rsub|2><right|rangle>\<otimes\>\<ldots\>\<otimes\><mid|\|>q<rsub|n<rsub|q>><right|rangle>
  </equation*>

  is described by <with|mode|math|2<rsup|n<rsub|q>>>-component complex array.
  In turn, the gate matrices <with|mode|math|U<rsub|i>>, are
  <with|mode|math|2<rsup|n<rsub|q>>\<times\>2<rsup|n<rsub|q>>> arrays of
  complex numbers, too. One can see \ that dimensions of arrays grows
  exponentially with the number of qubits <with|mode|math|n<rsub|q>>: this is
  a main origin of exponential slowing down of simullations of quantum
  algorithms on common ``classical'' computers.

  The number of quantum gates <with|mode|math|M> in quantum algorithms is in
  general a power-like function of <with|mode|math|n<rsub|q>>. In fact, all
  of the possible gates can be reduced into very restricted set of elementary
  gates, each of that affects one or two qubits, leaving the rest untouched.\ 

  As a result, the classical code, simulating the quantum computation is a
  lengthy chain of several gates composed in a very complicated inhomogeneous
  pattern (very similar to DNA chain!). In order reduce mistakes in writing
  such code, we invent a simple human interface to objects of simulation.

  <subsection|Main objects and their properties.>

  The main object is the quantum register, or wavefunction of its quantum
  state. Corresponding type defined in header file <verbatim|qubits.h> is
  <verbatim|QBitsWaveFunction>:

  <\code>
    #include ''qubits.h''

    QBitsWaveFunction Psi(nq); \ \ // nq is qubits number
  </code>

  One can perform on the quantum state the following operations:

  <\code>
    QBitsWaveFunction Psi2(Psi) \ // make a clone of the state Psi

    \;

    QBitsWaveFunction Psi3(nq);

    Psi3(nq)=Psi; \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ // copy of state Psi\ 

    \;

    double\<less\>complex\<gtr\> z;

    ...

    Psi.RescaleBy(z); \ \ \ \ \ \ \ \ \ \ \ // rescale by a complex factor;

    \;

    Psi3.Sum(Psi2,Psi); \ \ \ \ \ \ \ \ \ // calculate a sum of two
    wavefunctions

    \;

    Psi.Allign(); \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ // set all qubits up
  </code>

  One can perform multiplication of <with|mode|math|j>-th quibit state by any
  Pauli matrix <with|mode|math|\<sigma\>>:

  <\code>
    Psi.SigmaX(j);

    Psi.SigmaY(j);

    Psi.SigmaZ(j);
  </code>

  the Walsh-Hadamard transformation:

  <\code>
    Psi.WH_tr(j);
  </code>

  and rotate <with|mode|math|j>-th qubit state by angle Phi:

  <\code>
    Psi.RotateQBit(j,Phi);
  </code>

  Next operation is useful to simulate interaction between two qubits:

  <\code>
    Psi.InteractQubits(j1,j2,g);
  </code>

  which in fact corresponds to applying to register state the operator

  <\equation*>
    exp(-i g\<sigma\><rsub|z><rsup|(j1)>\<sigma\><rsub|z><rsup|(j2)>)<left|\|>X<right|rangle>.
  </equation*>

  Next important operations are <em|Control-Not> and <em|Control-Control-Not>
  gates applied to \ qubits <with|mode|math|j1>, <with|mode|math|j2> and
  <with|mode|math|j3>:

  <\code>
    Psi.Cnot(j1,j2);

    Psi.CCnot(j1,j2,j3);
  </code>

  \ The contents of <verbatim|Psi> can be printed by command
  <verbatim|Psi.print();> to stdout, into three collumn form: first is plain
  index of the complex array, second and third are real and imaginary part of
  amplitude. The correspondence between plain index and states of qubits is:

  <\equation*>
    j=s<rsub|1>+2s<rsub|2>+\<ldots\>+2<rsup|n<rsub|q>-1>s<rsub|n<rsub|q>>
  </equation*>

  where <with|mode|math|s<rsub|i>> equal 1 and 0 for ``up'' and ``down''
  states of <with|mode|math|i>-th qubit, respectively.

  \ \ \ In fact, in mutiplication and sum one can use more simpler interface:

  <\code>
    Psi2=Psi*z; \ \ // similar to Rescale by, but content of Psi remains
    unchanged

    Psi2=z*Psi;

    \;

    z=Psi1*Psi2; \ // scalar product

    Psi3=Psi1+Psi2; // sum of two states
  </code>

  \ <subsection|Advanced interface to objects: basic operations and gates.>

  Addressing to gates as properties of wavefunction is not convenient.
  Instead we introduce a set of new objects, which can simplify appearence of
  code. Most of their definitions are collected in the header file
  <verbatim|qAlgebra.h>. \ Let us start with prepared quantum state object
  Psi and applied to it several described above operations:

  <\code>
    #include ''qAlgebra.h''

    QBitsWaveFunction Psi(nq); \ \ // nq is qubits number

    ...

    Psi \<less\>\<less\> X(j1,j2) \<less\>\<less\> WH(j3,j4) \<less\>\<less\>
    rotQBitBy(angle,j5,j6) \<less\>\<less\> Cnot(ic,iq);

    Psi \<less\>\<less\> X(m1) \<less\>\<less\> WH(m2) \<less\>\<less\>
    rotQBitBy(angle,m3) \<less\>\<less\> CCnot(ic1,ic2,iq);

    \;
  </code>

  At first single line we perform on Psi subsequently:

  <\enumerate-numeric>
    <item>Apply matrix <with|mode|math|\<sigma\><rsub|x>> to qubits from
    <with|mode|math|j1>-th to <with|mode|math|j2>-th;

    <item>Apply Walsh-Hadamard transformation to qubits from
    <with|mode|math|j3>-th to <with|mode|math|j4>-th;

    <item>Rotate qubits from <with|mode|math|j5>-th to <with|mode|math|j6>-th
    by angle ``<verbatim|angle>'';

    <item>Apply Control-Not gate, with control qubit <verbatim|ic> and
    working qubit <verbatim|iq>.
  </enumerate-numeric>

  The single qubit operations are presented by the second line, where
  <verbatim|m1>, <verbatim|m2> and <verbatim|m3> are indices of qubits; at
  the end of second line we give an example of Control-Control-Not gate
  operation. After all the object <verbatim|Psi> contains the cumulative
  result of both lines.

  The syntax of this interface is very simple and self-explaning: sequence of
  operations from left to right is very natural for human reading and
  direction of symbol ``<verbatim|\<less\>\<less\>>'' point to the object, to
  which the action is applied.

  \;

  <section|Extentions.>\ 

  <subsection|Qubits interactions.>

  Interactions of qubits depend on their mutual positions. In our simulations
  we have assumed that they are placed on sites of simple rectangular
  lattice, and interactions among them and qubits imperfections are described
  by Hamiltonian

  <\equation*>
    H<rsub|s>=<big|sum><rsub|i>a<rsub|i>\<sigma\><rsub|i><rsup|z>+<big|sum><rsub|i
    j>b<rsub|i j>\<sigma\><rsub|i><rsup|x>\<sigma\><rsub|j><rsup|x>
  </equation*>

  where couplings <with|mode|math|a<rsub|i>, b<rsub|i j>> are random numbers,
  distributed homogeneously inside <with|mode|math|[-\<alpha\>,\<alpha\>]>
  and <with|mode|math|[-\<beta\>,\<beta\>]> respectively.\ 

  Implementation of object, providing simulation of these interactions is
  located in the header files <verbatim|qLattice.h> and
  <verbatim|qAlgebra.h>:

  <\code>
    #include ''qLattice.h''

    #include ''qAlgebra.h''

    \;

    Lattice L(Lx,Ly,Alpha,Beta); \ \ // create a lattice of size Lx by Ly
    qubits }

    \;

    L.Rand(); \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ // generate a new set
    of random couplings

    L.Perturb(Psi); \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ // introduce perturbations
    into state Psi

    \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ // by time
    evolution with Hamiltonian
  </code>

  In fact, the best way to introduce perturbation is

  <\code>
    Psi \<less\>\<less\> Pert();
  </code>

  <subsection|Interaction with enviroment.>

  The underlying mechanism of decoherence is assumed a random flip of a qubit
  <with|mode|math|<mid|\|>1<right|rangle>
  \<rightarrow\><mid|\|>0<right|rangle>>, with a rate
  <with|mode|math|\<Gamma\>>. The necessary initialization of the process is
  creating an object of type <verbatim|Jump>:

  <\code>
    #include ''qJump.h''

    Jump(Gamma*dt);
  </code>

  Then one can simply act on the wave function <verbatim|Psi>:

  <\code>
    Psi \<less\>\<less\> Jump(Gamma*dt);
  </code>

  As a result we get a state which either is the orignal one but damped by
  the probability amplitude of no qubit be flipped, or it start a new quantum
  branch. \ 

  \;

  <section|Applications.>

  This library is used in simulations of Grover problem with imperfections
  (subdirectory <verbatim|Grover>) and decoherence effects, caused by
  interactions with enviroment (subdirectory <verbatim|DecoGr>). The former
  one is an earlier version of the library, where all objects are included in
  a single header file. The latter is the last version, actually described in
  this document.\ 

  \;
</body>

<\initial>
  <\collection>
    <associate|language|english>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|auto-1|<tuple|1|1>>
    <associate|auto-2|<tuple|2|1>>
    <associate|auto-3|<tuple|2.1|2>>
    <associate|auto-4|<tuple|2.2|3>>
    <associate|auto-5|<tuple|3|3>>
    <associate|auto-6|<tuple|3.1|3>>
    <associate|auto-7|<tuple|3.2|4>>
    <associate|auto-8|<tuple|4|4>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|toc>
      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|1<space|2spc>Introdiction.>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-1><vspace|0.5fn>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|2<space|2spc>The
      paradigm.> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-2><vspace|0.5fn>

      <with|par-left|<quote|1.5fn>|2.1<space|2spc>Main objects and their
      properties. <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-3>>

      <with|par-left|<quote|1.5fn>|2.2<space|2spc>Advanced interface to
      objects: basic operations and gates.
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-4>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|3<space|2spc>Extentions.>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-5><vspace|0.5fn>

      <with|par-left|<quote|1.5fn>|3.1<space|2spc>Qubits interactions.
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-6>>

      <with|par-left|<quote|1.5fn>|3.2<space|2spc>Interaction with
      enviroment. <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-7>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|4<space|2spc>Applications.>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-8><vspace|0.5fn>
    </associate>
  </collection>
</auxiliary>