#ifndef _Q_PLOT_H_
#define _Q_PLOT_H_
#include <stdlib.h>
#include <ctype.h>
#include <stdio.h>
#include <math.h>
#include <complex>
#include "qubits.h"

class Husimi
{ public:
    int N,N2,n,Ns,nHus,Nw_q,Nw0_q; 
    complex<double> *wf;
    double *P,*w_q,sigma_q,sqrtN,xNorm;
    
//  ------- constructor
    Husimi(){P=w_q=0;};
    Husimi(QBitsWaveFunction& QB){ P=w_q=0; initHusimi(QB);};

     ~Husimi() {};


complex <double> psi(int i) 
    { while(i<0){ i+=N; return wf[i];}
      while(i>=N){ i-=N; return wf[i];}
      return wf[i];
    }; 

void initHusimi(QBitsWaveFunction& QBits)
    { 
      wf=QBits.wf; n=QBits.n; N=QBits.N; N2=N/2; 
      sqrtN=sqrt(double(N)); Ns=int(sqrtN); nHus=Ns*Ns;   //Husimi function is Ns x Ns matrix
                                                            // in general nHus < N !
      sigma_q=sqrtN/2; 
      Nw0_q=int(3*sigma_q); Nw_q=2*Nw0_q+1; 
      
      if(P) free(P); if(w_q) free(w_q);      
      P=(double*)calloc(nHus,sizeof(double)); for(int i=0; i<nHus; i++) P[i]=0;
      w_q=(double*)calloc(Nw_q,sizeof(double)); 
      for(int i=0; i<Nw_q; i++) w_q[i]=exp(-sqr(double(i-Nw0_q)/sigma_q));
    };       

void calcHusimi()
  { int Ns2=Ns/2; 
    for(int q=0; q<Ns; q++)
    { int qH=int(sqrtN*(q-Ns2));
      for(int p=0; p<Ns; p++)
      { int pH=int(sqrtN*(p-Ns2));
        complex <double> wH,wHi=0;
        for(int iq=-Nw0_q; iq<=Nw0_q; iq++)
	{ wH+=w_q[iq+Nw0_q]*exp(-complex<double>(0,6.283184*pH*iq/double(N)))*psi(qH+iq+N2);
        };
        P[q+Ns*p]+=sqr(abs(wH)); 
      };  
    };  
  };
  
void printHusData(char * fname)
  { xNorm=0; for(int i=0; i<nHus; i++) xNorm+=P[i];
    FILE* f=fopen(fname,"w");
    for(int p=0; p<Ns; p++)
    { 
      for(int q=0; q<Ns; q++) fprintf(f,"%10.7f ",sqrt(P[q+Ns*p]*Ns/xNorm)); 
      fprintf(f,"\n");
    };
    fclose(f); 
  };

void HusDataXYZ(char * fname)
  { xNorm=0; for(int i=0; i<nHus; i++) xNorm+=P[i];
    FILE* f=fopen(fname,"w");
    int Ns2=Ns/2;
    for(int p=0; p<Ns; p++)
    { 
      for(int q=0; q<Ns; q++) fprintf(f,"%10.2f %10.2f %10.7f \n ",(q-Ns2)*sqrtN, (p-Ns2)*sqrtN, P[q+Ns*p]*Ns/xNorm); 
    };
    fclose(f); 
  };


Husimi& operator << (QBitsWaveFunction& QR) 
  { if(N!=QR.N)
    { printf("Invalid dimension of wave function: %d != %d\n",QR.N,N);
      abort();
    }; 
    wf=QR.wf; calcHusimi();
    return *this; 
  };

};




#endif
