#ifndef _Q_JUMP_H_
#define _Q_JUMP_H_
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <complex>
#include "qubits.h"

static double Njump,Nbranch,wNbranch; 

class Jump
{ public:
    int nLind,n;
    long N,N2; 
    complex<double> *wf;
    double *P,Pcur,Gdt;
    
//  ------- constructor
    Jump(double GammaDt){ Gdt=GammaDt;};

     ~Jump() {};

void quJump(QBitsWaveFunction& QBits)
        { //printf("quJump \n");
	  Njump+=1;
	  wf=QBits.wf; n=QBits.n; N=QBits.N; N2=N/2; nLind=n+1;
	  P=(double*)calloc(nLind,sizeof(double)); for(int k=0; k<nLind; k++) P[k]=0; 
          CalcProbabilities();
	  double eta=drand48(),Pk;
	  if(eta<=(Pk=P[0])) { QBits.RescaleBy(sqrt(P[0]));}
	  else
	    for(int k=1; k<nLind; k++)
	      if(eta<=(Pk+=P[k])) { //printf("P[k]=%10.5f, k=%d wNbranch=%10.5f %10.5f %10.5f \n",P[k],k,wNbranch,Nbranch,Njump); 
	                            SwapRescaleBy(k,sqrt(P[k])); Nbranch+=1; wNbranch+=P[k]; 
				    break; };
          free(P);
	  //printf("quJump - done \n");
	};


void CalcProbabilities()
  { //printf("calc prob\n");
    Pcur=0;
    for(int i=1; i<N2; i++)
    { double wi=(sqr(abs(wf[i]))+sqr(abs(wf[i+N2]))); Pcur+=wi;
      int k2=1;
      for(int k=1; k<nLind; k++)
      { if(i&k2) P[k]+=wi;  
        k2=k2<<1;
      };
    };
    if(Pcur==0) { P[0]=1; for(int k=1; k<nLind; k++) P[k]=0; return;};
    double Ps=0;
    for(int k=1; k<nLind; k++){ P[k]*=Gdt/Pcur; Ps+=P[k];};
    P[0]=double(1)-Ps;
    if(P[0]<0) { printf("too large Gamma*dt, P[0] is negative!\n"); abort(); };
    //printf("calc prob-done\n");
  }; 
     
void SwapRescaleBy(int k,double a)  // k is the index of Lindblad operator = the qubit index +1 ! 
  { int shift_i; shift_i=1<<(k-1);
    for(int i=shift_i; i<N;i++) { wf[i-shift_i]=wf[i]*a; wf[i]=0; };
  };
};

QBitsWaveFunction& operator << (QBitsWaveFunction& QR, Jump G) 
  { G.quJump(QR); 
    return QR; 
  };

#endif
