
      program noisyqpa

c
c     Program simulating the quantum privacy amplification map
c     with noisy apparatus
c

      implicit double precision (a-h,o-z)

      complex*16 rho12(0:3,0:3),rhotot(0:15,0:15),uvrot(0:3,0:3),
     *   uvtot(0:15,0:15),cnot2(0:15,0:15),p00(0:3,0:3),p11(0:3,0:3),
     *   p00tot(0:15,0:15),p11tot(0:15,0:15),iden(0:3,0:3),
     *   fktot(0:3,0:15,0:15),rhotn(0:15,0:15)

      open(7,file='noisyfido.dat')
      open(8,file='noisyeff.dat')

c
c     FALPHA intrusion parameter
c     NMAP number of map iterations
c     NCHAN select noise channel
c     THETA angle determining the strength of noise
c

      open(1,file='noisyqpa.in')

      read (1,*) falpha 
      read (1,*) nmap
      read (1,*) nchan
      read (1,*) theta

      close (1)

      alph=1.d0/sqrt(2.d0)+falpha*(2.d0/sqrt(6.d0)-1.d0/sqrt(2.d0))
      xfrac=sqrt(0.5d0-0.75d0*alph**2)
      gamm=0.5d0*alph-xfrac
      delt=0.5d0*alph+xfrac
      beta=0.d0
      fido=0.5d0*(alph+delt)**2
      err=1.d0-fido
      n=0
      write (7,900) n,fido,err

c
c     Load initial density matrix RHO12 for each two-qubit pair
c

      do i=0,3
       do j=0,3
        rho12(i,j)=0.d0 
       end do 
      end do 
      rho12(0,0)=0.5d0*(alph**2+delt**2)
      rho12(3,3)=rho12(0,0)
      rho12(1,1)=0.5d0-rho12(0,0)
      rho12(2,2)=rho12(1,1)
      rho12(0,3)=alph*delt
      rho12(3,0)=rho12(0,3)
      rho12(1,2)=beta*gamm
      rho12(2,1)=rho12(1,2)

c
c     Compute initial global density matrix RHOTOT
c

      call tensprod(rho12,rho12,rhotot) 

c
c     Load the unitary rotation matrix UVROT 
c

      uvrot(0,0)=0.5d0
      uvrot(0,1)=0.5d0*(0.d0,1.d0)
      uvrot(0,2)=0.5d0*(0.d0,-1.d0)
      uvrot(0,3)=0.5d0
      uvrot(1,0)=0.5d0*(0.d0,1.d0)
      uvrot(1,1)=0.5d0
      uvrot(1,2)=0.5d0
      uvrot(1,3)=0.5d0*(0.d0,-1.d0)
      uvrot(2,0)=0.5d0*(0.d0,-1.d0)
      uvrot(2,1)=0.5d0
      uvrot(2,2)=0.5d0
      uvrot(2,3)=0.5d0*(0.d0,1.d0)
      uvrot(3,0)=0.5d0
      uvrot(3,1)=0.5d0*(0.d0,-1.d0)
      uvrot(3,2)=0.5d0*(0.d0,1.d0)
      uvrot(3,3)=0.5d0

c
c     Compute UVTOT = UVROT \otimes UVROT 
c

      call tensprod(uvrot,uvrot,uvtot)

c
c     Load CNOT2 = CNOT13 \otimes CNOT24
c

      do i=0,15
       do j=0,15
        cnot2(i,j)=0.d0
       end do 
      end do 
      cnot2(0,0)=1.d0
      cnot2(1,1)=1.d0
      cnot2(2,2)=1.d0
      cnot2(3,3)=1.d0
      cnot2(4,5)=1.d0
      cnot2(5,4)=1.d0
      cnot2(6,7)=1.d0
      cnot2(7,6)=1.d0
      cnot2(8,10)=1.d0
      cnot2(10,8)=1.d0
      cnot2(9,11)=1.d0
      cnot2(11,9)=1.d0
      cnot2(12,15)=1.d0
      cnot2(15,12)=1.d0
      cnot2(13,14)=1.d0
      cnot2(14,13)=1.d0

c
c     Load projectors P00 and P11 and identity IDEN
c

      do i=0,3
       do j=0,3
        p00(i,j)=0.d0
        p11(i,j)=0.d0
       end do 
      end do 
      p00(0,0)=1.d0
      p11(3,3)=1.d0

      do i=0,3
       do j=0,3 
        iden(i,j)=0.d0
       end do 
      end do 
      do i=0,3
       iden(i,i)=1.d0
      end do 

c
c     Compute P00TOT = IDEN \otimes P00 and P11TOT = IDEN \otimes P11
c

      call tensprod(iden,p00,p00tot)
      call tensprod(iden,p11,p11tot)

c
c     Load Kraus operators acting non trivially only 
c     on the most significant qubit
c

      call kraus(fktot,nchan,theta)

      n=0
      psurvtot=1.d0
      write (8,900) n,psurvtot,psurvtot/2**n

c
c     Start map iterations
c

      do n=1,nmap 

c
c     Evolution due to U and V operators
c

       call rhoev(rhotot,uvtot,rhotn)

c
c     Noise channels
c

       call krausev(rhotn,fktot,rhotot)

c
c     CNOT operators
c

       call rhoev(rhotot,cnot2,rhotn)

c
c     Measurements and post selection
c

       call rhomeas(rhotn,p00tot,p11tot,rho12,psurv)
      
       fido=0.5d0*(rho12(0,0)+rho12(0,3)+rho12(3,0)+rho12(3,3))
       err=1.d0-fido
c       do i=0,3
c        do j=0,3
c         print *,i,j,rho12(i,j)
c        end do 
c       end do 
c       print *, rho12(3,3)

       write (7,900) n,fido,err
      
       psurvtot=psurvtot*psurv

       write (8,900) n,psurvtot,psurvtot/2**n

c
c     Compute the new global density matrix RHOTOT
c

      call tensprod(rho12,rho12,rhotot) 

      end do 

      stop

900   format (i8,20e15.7) 

      end

*******************************************************************

      subroutine kraus(fktot,nchan,theta)

c
c     Compute the Kraus operators KFTOT for the noisy channel NCHAN
c

      implicit double precision (a-h,o-z)

      complex*16 fk(0:3,0:1,0:1),fktot(0:3,0:15,0:15),iden(0:7,0:7)

      do k=0,3
       do i=0,1
        do j=0,1 
         fk(k,i,j)=0.d0
        end do 
       end do 
      end do 
      do k=0,3
       do i=0,15
        do j=0,15 
         fktot(k,i,j)=0.d0
        end do 
       end do 
      end do 
      do i=0,7
       do j=0,7
        iden(i,j)=0.d0
       end do 
      end do  
      do i=0,7
       iden(i,i)=1.d0
      end do 

c
c     Noiseless channel for NCHAN=0
c

      if (nchan.eq.0) then 
       fk(0,0,0)=1.d0
       fk(0,1,1)=1.d0
      end if 

c
c     Bit flip channel for NCHAN=1
c

      if (nchan.eq.1) then 
       fk(0,0,0)=dcos(theta/2.d0)
       fk(0,1,1)=dcos(theta/2.d0)
       fk(1,0,1)=dsin(theta/2.d0)
       fk(1,1,0)=dsin(theta/2.d0)
      end if 

c
c     Phase flip channel for NCHAN=2
c

      if (nchan.eq.2) then 
       fk(0,0,0)=dcos(theta/2.d0)
       fk(0,1,1)=dcos(theta/2.d0)
       fk(1,0,0)=dsin(theta/2.d0)
       fk(1,1,1)=-dsin(theta/2.d0)
      end if 

c
c     Bit-phase flip channel for NCHAN=3
c

      if (nchan.eq.3) then 
       fk(0,0,0)=dcos(theta/2.d0)
       fk(0,1,1)=dcos(theta/2.d0)
       fk(1,0,1)=dsin(theta/2.d0)*(0.d0,-1.d0)
       fk(1,1,0)=dsin(theta/2.d0)*(0.d0,1.d0)
      end if 

c
c     Rotation about x-axis for NCHAN=4
c

      if (nchan.eq.4) then 
       fk(0,0,0)=dcos(theta/2.d0)
       fk(0,1,1)=dcos(theta/2.d0)
       fk(0,0,1)=dsin(theta/2.d0)*(0.d0,-1.d0)
       fk(0,1,0)=dsin(theta/2.d0)*(0.d0,-1.d0)
      end if 

c
c     Rotation about y-axis for NCHAN=5
c

      if (nchan.eq.5) then 
       fk(0,0,0)=dcos(theta/2.d0)
       fk(0,1,1)=dcos(theta/2.d0)
       fk(0,0,1)=-dsin(theta/2.d0)
       fk(0,1,0)=dsin(theta/2.d0)
      end if 

c
c     Rotation about z-axis for NCHAN=6
c

      if (nchan.eq.6) then 
       fk(0,0,0)=dcos(theta/2.d0)-dsin(theta/2.d0)*(0.d0,1.d0)
       fk(0,1,1)=dcos(theta/2.d0)+dsin(theta/2.d0)*(0.d0,1.d0)
      end if 

c
c     Displacement of the Bloch sphere along the +z axis for NCHAN=7
c

      if (nchan.eq.7) then 
       fk(0,0,0)=1.d0
       fk(0,1,1)=dcos(theta)
       fk(1,0,1)=dsin(theta)
      end if 

c
c     Displacement of the Bloch sphere along the -z axis for NCHAN=8
c

      if (nchan.eq.8) then 
       fk(0,0,0)=dcos(theta)
       fk(0,1,1)=1.d0
       fk(1,1,0)=dsin(theta)
      end if 

c
c     Displacement of the Bloch sphere along the +x axis for NCHAN=9
c

      if (nchan.eq.9) then 
       fk(0,0,0)=0.5d0*(1.d0+dcos(theta))
       fk(0,0,1)=-0.5d0*(1.d0-dcos(theta))
       fk(0,1,0)=-0.5d0*(1.d0-dcos(theta))
       fk(0,1,1)=0.5d0*(1.d0+dcos(theta))
       fk(1,0,0)=0.5d0*dsin(theta)
       fk(1,0,1)=0.5d0*dsin(theta)
       fk(1,1,0)=-0.5d0*dsin(theta)
       fk(1,1,1)=-0.5d0*dsin(theta)
      end if 

c
c     Displacement of the Bloch sphere along the -x axis for NCHAN=10
c

      if (nchan.eq.10) then 
       fk(0,0,0)=0.5d0*(1.d0+dcos(theta))
       fk(0,0,1)=0.5d0*(1.d0-dcos(theta))
       fk(0,1,0)=0.5d0*(1.d0-dcos(theta))
       fk(0,1,1)=0.5d0*(1.d0+dcos(theta))
       fk(1,0,0)=-0.5d0*dsin(theta)
       fk(1,0,1)=0.5d0*dsin(theta)
       fk(1,1,0)=-0.5d0*dsin(theta)
       fk(1,1,1)=0.5d0*dsin(theta)
      end if 

c
c     Displacement of the Bloch sphere along the +y axis for NCHAN=11
c

      if (nchan.eq.11) then 
       fk(0,0,0)=0.5d0*(1.d0+dcos(theta))
       fk(0,0,1)=-0.5d0*(1.d0-dcos(theta))*(0.d0,-1.d0)
       fk(0,1,0)=-0.5d0*(1.d0-dcos(theta))*(0.d0,1.d0)
       fk(0,1,1)=0.5d0*(1.d0+dcos(theta))
       fk(1,0,0)=0.5d0*dsin(theta)*(0.d0,-1.d0)
       fk(1,0,1)=0.5d0*dsin(theta)
       fk(1,1,0)=0.5d0*dsin(theta)
       fk(1,1,1)=0.5d0*dsin(theta)*(0.d0,1.d0)
      end if 

c
c     Displacement of the Bloch sphere along the -y axis for NCHAN=12
c

      if (nchan.eq.12) then 
       fk(0,0,0)=0.5d0*(1.d0+dcos(theta))
       fk(0,0,1)=-0.5d0*(1.d0-dcos(theta))*(0.d0,1.d0)
       fk(0,1,0)=-0.5d0*(1.d0-dcos(theta))*(0.d0,-1.d0)
       fk(0,1,1)=0.5d0*(1.d0+dcos(theta))
       fk(1,0,0)=0.5d0*dsin(theta)*(0.d0,1.d0)
       fk(1,0,1)=0.5d0*dsin(theta)
       fk(1,1,0)=0.5d0*dsin(theta)
       fk(1,1,1)=0.5d0*dsin(theta)*(0.d0,-1.d0)
      end if 

c
c     Depolarizing channel for NCHAN=13
c

      if (nchan.eq.13) then 
       fk(0,0,0)=dcos(theta)
       fk(0,1,1)=dcos(theta)
       fk(1,0,1)=(1.d0/sqrt(3.d0))*dsin(theta)
       fk(1,1,0)=(1.d0/sqrt(3.d0))*dsin(theta)
       fk(2,0,1)=(1.d0/sqrt(3.d0))*dsin(theta)*(0.d0,-1.d0)
       fk(2,1,0)=(1.d0/sqrt(3.d0))*dsin(theta)*(0.d0,1.d0)
       fk(3,0,0)=(1.d0/sqrt(3.d0))*dsin(theta)
       fk(3,1,1)=-(1.d0/sqrt(3.d0))*dsin(theta)
      end if 
       
      do k=0,3
       do i=0,15
        do j=0,15
         i1=i/8
         j1=j/8
         i2=i-8*i1
         j2=j-8*j1
         fktot(k,i,j)=fk(k,i1,j1)*iden(i2,j2)
        end do 
       end do 
      end do 

      return

      end 
      
*******************************************************************

      subroutine tensprod(rhoa,rhob,rhotot)

c
c     Subroutine computing the tensor product 
c     of two 4\times 4 operators
c     (RHOTOT = RHOA \otimes RHOB)
c

      implicit double precision (a-h,o-z)

      complex*16 rhoa(0:3,0:3),rhob(0:3,0:3),rhotot(0:15,0:15)
     
      do i=0,15
       do j=0,15
        i1=i/4
        j1=j/4
        i2=i-4*i1
        j2=j-4*j1
        rhotot(i,j)=rhoa(i1,j1)*rhob(i2,j2)
       end do 
      end do 

      return

      end 
      
*******************************************************************

      subroutine rhoev(rho,umat,rhon)

c
c     Subroutine computing 
c     RHON = UMAT * RHO * UMAT^\dagger 
c     for 16\times 16 matrices
c

      implicit double precision (a-h,o-z)

      complex*16 umat(0:15,0:15),rho(0:15,0:15),rhon(0:15,0:15),
     *   rhot(0:15,0:15)

      do i=0,15
       do j=0,15
        rhot(i,j)=0.d0
        do k=0,15 
         rhot(i,j)=rhot(i,j)+rho(i,k)*conjg(umat(j,k))
        end do 
       end do 
      end do 

      do i=0,15
       do j=0,15
        rhon(i,j)=0.d0
        do k=0,15 
         rhon(i,j)=rhon(i,j)+umat(i,k)*rhot(k,j)
        end do 
       end do 
      end do 

      return
  
      end

*******************************************************************

      subroutine krausev(rho,fk,rhon)

c
c     Subroutine computing 
c     RHON = \sum_i=0^3 (FK(i) * RHO * FK(i)^\dagger) 
c     for 16\times 16 matrices
c

      implicit double precision (a-h,o-z)

      complex*16 fk(0:3,0:15,0:15),rho(0:15,0:15),rhon(0:15,0:15),
     *   rhot(0:3,0:15,0:15)

      do kr=0,3
       do i=0,15
        do j=0,15
         rhot(kr,i,j)=0.d0
         do k=0,15 
          rhot(kr,i,j)=rhot(kr,i,j)+rho(i,k)*conjg(fk(kr,j,k))
         end do 
        end do 
       end do 
      end do 

      do i=0,15
       do j=0,15
        rhon(i,j)=0.d0
        do kr=0,3 
         do k=0,15 
          rhon(i,j)=rhon(i,j)+fk(kr,i,k)*rhot(kr,k,j)
         end do 
        end do 
       end do 
      end do 

      return
  
      end

*******************************************************************

      subroutine rhomeas(rho,p00,p11,rho12,psurv)

c
c     Subroutine computing the post measurement state
c     for the quantum privacy amplification protocol
c

      implicit double precision (a-h,o-z)

      complex*16 rho(0:15,0:15),rhon(0:15,0:15),p00(0:15,0:15),
     *   p11(0:15,0:15),rhot00(0:15,0:15),rhot11(0:15,0:15),
     *   rhon00(0:15,0:15),rhon11(0:15,0:15),rho12(0:3,0:3)

      do i=0,15
       do j=0,15
        rhot00(i,j)=0.d0
        do k=0,15 
         rhot00(i,j)=rhot00(i,j)+rho(i,k)*p00(j,k)
        end do 
       end do 
      end do 

      do i=0,15
       do j=0,15
        rhot11(i,j)=0.d0
        do k=0,15 
         rhot11(i,j)=rhot11(i,j)+rho(i,k)*p11(j,k)
        end do 
       end do 
      end do 

      do i=0,15
       do j=0,15
        rhon00(i,j)=0.d0
        do k=0,15 
         rhon00(i,j)=rhon00(i,j)+p00(i,k)*rhot00(k,j)
        end do 
       end do 
      end do 

      do i=0,15
       do j=0,15
        rhon11(i,j)=0.d0
        do k=0,15 
         rhon11(i,j)=rhon11(i,j)+p11(i,k)*rhot11(k,j)
        end do 
       end do 
      end do 

      do i=0,15
       do j=0,15 
        rhon(i,j)=rhon00(i,j)+rhon11(i,j)
       end do 
      end do 

      psurv=0.d0
      do i=0,15
       psurv=psurv+rhon(i,i)
      end do 

      do i=0,15
       do j=0,15
        rhon(i,j)=rhon(i,j)/psurv
       end do 
      end do 

      do i=0,3
       do j=0,3 
        rho12(i,j)=0.d0
        do k=0,3
         rho12(i,j)=rho12(i,j)+rhon(4*i+k,4*j+k)
        end do
       end do 
      end do 

      return
  
      end

