	PROGRAM QTRA_qmcwf
	implicit none  




c       -----------
c       Definitions
c       -----------

c       Random numbers
	integer idum
	real ran1
	real*8 eps
	
c       Parameters
	integer NN
	parameter(NN=10)  !Qubits number
	integer Ntray     !Quantum trajectories number
	integer iter      !Number of steps in dissipation
	integer Ngrid     !Number of sampling grid points
	integer channel   !Dissipative channel code
	integer algorithm !Algorithm code

c       Auxiliar variables
	integer i,j,o,piter	!loop variables
	real*8 gam		!dissipative coupling
	real*8 norma		!normalization

c       Fidelity
	real*8 Fid,Fid2,Fid3 

c       State vector variables
	complex*8 VE(0:2**NN-1),VE2(0:2**NN-1)
	complex*8 VEtemp
	complex*8 alpha(0:2**(NN)-1) !initial values
	
c       Baker's map variables
	integer Nsteps

c       Parallel variables
	integer ierr,myid,nproc
	integer Nsync !random numbers synchrony
	real*8 Fidp(200),Fidg(200)     
	real*8 Fidp2(200),Fidg2(200) 





c       ---------------------------------------------
c       calls parallel subroutines

	include 'mpif.h'
	call MPI_INIT(ierr)
	call MPI_COMM_SIZE(mpi_comm_world,nproc,ierr)
	call MPI_COMM_RANK(mpi_comm_world,myid,ierr)
c       ---------------------------------------------

c       ---------------------------------------------------
c       Definition of parameters:

	Nsteps=1 	!Number of Baker's steps
	gam=.004 	!Coupling constant
	iter=5    !40 	!Number of steps in dissipation
	Ntray=700 !400 	!Number of QTs
	Ngrid=10 !0 !50 !Number of coupling values
	channel=4	!Dissipative channel (see distep sub)
	algorithm=2     !Selected algorithm
c       ---------------------------------------------------
	
c       Output file (opened by master)

c       -----------------------------------------------------------
	if (myid.eq.0) then
	open(unit=31,file='fidelity.out',status='unknown')
	end if
c       -----------------------------------------------------------	

c       ---------------------------------------
c       random numbers for initial state vector

	call AlphaGen(NN,alpha,idum,0) !flag set to In State=random 2
c       ---------------------------------------


c       Coupling constant loop begins:

	do piter=0,Ngrid !Sweeping of several gamma values
c	do piter=0,0     !Individual point

c       --------------------------------------
c       Clears fidelity at each coupling value 

	Fid=0.d0  !Fidelity
	Fid3=0.d0 !Dispersion (error)
c       --------------------------------------

c       ---------------------------------------
c       Sets the value of the coupling constant 

	if (algorithm.eq.1) then 
	   if (channel.le.1) then
	   gam=dfloat(piter)/dfloat(Ngrid) 
	   else
	   gam=dfloat(piter)/dfloat(Ngrid)/10. 
	   end if
	else
	   if (channel.le.1) then
	   gam=dfloat(piter)/dfloat(Ngrid)/10. 
	   else
	   gam=dfloat(piter)/dfloat(Ngrid)/200. 
	   end if
	end if
c	gam=gam/20.*.3 !This line fixes gamma
c       ---------------------------------------


c       quantum trajectories iterations:

	do o=1, Ntray/nproc


c       Random seed

	   if (myid.gt.0) then 
	      do i=1,10*myid
		eps=ran1(idum)
	      end do !i
	   idum=int(eps*1000000)
	   end if


c       ---------------------------------------
c       Sets the initial state

	call InitialVE(VE,NN,alpha,3)
c       ---------------------------------------

c       -----------------------------------------------------
c       Calls the selected quantum algorithm

	if (algorithm.eq.1) then 
	 call TeleFidelity(VE,NN,iter,gam,idum,channel,Fid2)
	else
	 call BakerFidelity(VE,NN,iter,gam,idum,channel,alpha,
     1                           Fid2,Nsteps)
	end if
c       -----------------------------------------------------

c       --------------------------
c       Records Fidelity and error

	Fid=Fid+Fid2
	Fid3=Fid3+Fid2**2
c       --------------------------

c       -------------------
c       Trajectory "o" ends

	end do	!o
c       -------------------

c       --------------------------------------------
c       Fidelity and error average of each point 
c       and process

	Fid=Fid/dfloat(Ntray/nproc)
	Fidp(piter+1)=Fid

	Fid3=Fid3/dfloat(Ntray/nproc)
	Fidp2(piter+1)=Fid3
c       --------------------------------------------

c       ------------------------------
c       Ends loop of coupling constant

	end do !piter
c       ------------------------------

c       ----------------------------------------------------------
c	Gathers information from each processor 
c       and performs final average on master

	call MPI_REDUCE(Fidp,Fidg,Ngrid+1,mpi_double_precision,
     1	mpi_sum,0,MPI_COMM_WORLD,ierr) !fidelity

	call MPI_REDUCE(Fidp2,Fidg2,Ngrid+1,mpi_double_precision,
     1  mpi_sum,0,MPI_COMM_WORLD,ierr) !dispersion (error)	
c       ----------------------------------------------------------

c       ----------------------------------------------------------
c       Average and output (master):

	if (myid.eq.0) then 
	 do piter=0, Ngrid
	  Fid=Fidg(piter+1)/dfloat(nproc)
	Fid2=dabs(Fidg2(piter+1)/dfloat(nproc)-Fid**2) !dispersion
	Fid2=dsqrt(Fid2/dfloat(Ntray/nproc)/dfloat(nproc))
	   
c       ---------------------------------------
c       Sets the value of the coupling constant 

	if (algorithm.eq.1) then 
	   if (channel.le.1) then
	   gam=dfloat(piter)/dfloat(Ngrid) 
	   else
	   gam=dfloat(piter)/dfloat(Ngrid)/10. 
	   end if
	else
	   if (channel.le.1) then
	   gam=dfloat(piter)/dfloat(Ngrid)/10. 
	   else
	   gam=dfloat(piter)/dfloat(Ngrid)/200. 
	   end if
	end if
c	gam=gam/20.*.3 !This line fixes gamma
c       ---------------------------------------

c          Output only done by master

 	   write (31,*) gam,Fid,Fid2 !,conaz !sin despol	   
	 end do !piter
	end if
c       ----------------------------------------------------------

c       -------------------
c       closes output file

	if (myid.eq.0) then
	close (31)
	end if
c       -------------------

c       -----------------------
c       closing standard

	call MPI_FINALIZE(ierr)
c       -----------------------	

c       the program ends here.//

	stop 
	end








c       #############################################################

c                          S U B R O U T I N E S 
c                             (and functions)

c       #############################################################

c       #############################################################

	subroutine AlphaGen(NN,alpha,idum,flag)
	implicit none

	integer i,flag,NN,idum
	complex*8 alpha(0:2**(NN)-1)      
	real*8 faseR,pi,norma              	
	real ran1

c       Generates random chain of NN-2 qubits
c       the same for each quantum trajectory 
c       and coupling value.//
c       -flag=0 gives random phases
c       -flag=1 gives random reals

	pi=dasin(1.d0)*2.d0

	   idum=-127654  
	   do i=0, 2**(NN)-1
	      if (flag.eq.0) then
	       faseR=ran1(idum)*2.*pi
	       alpha(i)=cmplx(dcos(faseR),dsin(faseR))
	      else
	       alpha(i)=cmplx(ran1(idum),0.)
	      end if
	   end do !i
	   norma=0.
	   do i=0, 2**(NN)-1
	      norma=norma+conjg(alpha(i))*alpha(i)
	   end do !i
	   norma=dsqrt(norma)
	   do i=0, 2**(NN)-1
	      alpha(i)=alpha(i)/norma  
	   end do !i

	return
	end 
	
c	subroutine ends here.//

c       #############################################################

c       #############################################################

	subroutine InitialVE(VE,NN,alpha,flag)
	implicit none

	integer i,j,flag,NN
	complex*8 alpha(0:2**(NN)-1)      	
c       State vector variables:

	complex*8 VE(0:2**NN-1)


c       Gives initial state vector values, where:
c       -flag=0 Bell pair
c       -flag=1 Bell pair + noise
c	-flag=2 arbitrary state


	if (flag.eq.0) then

c       Initial state vector -> Bell pair: 
	   do i=0, 2**NN-1
	      VE(i)=(0.,0.)
	   end do !i
c          Hadamard followed by Cnot to |0>: 
	   VE(0)=cmplx(1./sqrt(2.),0.) 
	   VE(3)=cmplx(1./sqrt(2.),0.)

	else if (flag.eq.1) then

c       Initial state vector -> Bell pair + noise: 
	   do i=0, 2**NN-1
	    VE(i)=(0.,0.)
	   end do !i
c          State vector (direct product): 
	   do j=0, 2**(NN-2)-1
	    VE(j*4)=alpha(j)/sqrt(2.) 
	    VE(j*4+3)=alpha(j)/sqrt(2.)
	   end do !j

	else if (flag.eq.2) then
	
	   do i=0, 2**NN-1
	    VE(i)=(0.,0.)
	   end do !i
	   VE(2**NN-1)=1.0

	else if (flag.eq.3) then 

	   do i=0, 2**NN-1
	    VE(i)=alpha(i)
	   end do !i

	end if

	return
	end

c	subroutine ends here.//

c       #############################################################

c       #############################################################
	
	subroutine TeleFidelity(VE,NN,iter,gam,idum,channel,Fid2)
	implicit none

	integer l,NN,iter,idum,channel,m,n
	integer s1,s2,i,j
	real*8 gam,Fid2,norma

c       State vector variables:
	complex*8 VE(0:2**NN-1),VE2(0:2**NN-1)

 	complex*8 aa,bb !state to teleport

c       Fidelity variables:
	integer M1,N1
	complex*8 A(0:7,0:7),B(0:7,0:7),C(0:7,0:7)
	complex*8 RHOr(0:7,0:7)


	do l=2, NN-1

c       -------------------------------------------
c       Applies the noise and swap

	   m=l-1
	   n=l

	   call distep(VE,NN,gam,iter,idum,channel)

	   call FSWAP(VE,NN,m,n)
c       -------------------------------------------

	end do !l


c       ------------------------------------------
c       FastFidelity (teleportation)
c       ------------------------------------------

	aa=cmplx(1/sqrt(2.),0.) !State to teleport
	bb=cmplx(1/sqrt(2.),0.)

	do i=0, 7
	   do j=0, 7
	      RHOr(i,j)=0.
	   end do !j
	end do !i

c       ->Calculation of reduced matrix: qubit 0 and NN-1<-

	s1=NN-1
	s2=0
	call PTraceV(VE,NN,RHOr,s1,s2)

c       ->Coupling with the unknown Psi<- 

	  do i=0, 7
	     do j=0, 7
	        A(i,j)=0.
	        B(i,j)=0.
	        C(i,j)=0.
	     end do !j
	  end do !i
	
	do i=0, 3
	   do j=0, 3
	      A(i,j)=RHOr(i,j)
	   end do !j
	end do !i

	B(0,0)=abs(aa)**2
	B(0,1)=conjg(bb)*aa
	B(1,0)=conjg(aa)*bb
	B(1,1)=abs(bb)**2

	M1=1
	N1=3
	call Pdir(A,B,C,M1,N1) 


c       ->Projector definition 
c       over Bell pair phi+
c       in the reduced space<-

	B(0,0)=0.
	B(0,1)=0.
	B(1,0)=0.
	B(1,1)=0.

	B(0,0)=0.5
	B(3,3)=0.5
	B(4,4)=0.5
	B(7,7)=0.5
	B(0,3)=0.5
	B(4,7)=0.5
	B(3,0)=0.5
	B(7,4)=0.5

c       ->Bell's projection<-

	M1=7
	call Mmult(B,C,A,M1)	

	norma=0.
	do i=0, 7
	   norma=norma+real(A(i,i))
	end do !i

	call Mmult(A,B,C,M1)
	
	do i=0, 7
	   do j=0, 7
	      RHOr(i,j)=C(i,j)/norma
	   end do !j
	end do !i

c       ->Fidelity calculation<- 

c	 Partial trace over RHOr
c        that leads to the space of Bob's qubit:
	
	C(0,0)=0.
	C(0,1)=0.
	C(1,0)=0.
	C(1,1)=0.
	do i=0,3
	 C(0,0)=C(0,0)+RHOr(i,i)
	 C(0,1)=C(0,1)+RHOr(i,4+i)
	 C(1,0)=C(1,0)+RHOr(4+i,i)
	 C(1,1)=C(1,1)+RHOr(4+i,4+i)	   
	end do !i

c       ->Unknown state density matrix<-

	A(0,0)=abs(aa)**2
	A(0,1)=conjg(bb)*aa
	A(1,0)=conjg(aa)*bb
	A(1,1)=abs(bb)**2

	M1=1
	call Mmult(A,C,B,M1)

c	->trace=fidelity<-

	Fid2=0.
	do i=0,1 
	   Fid2=Fid2+B(i,i)
	end do !i

	
	return
	end

c       subroutine ends here.//

c       #############################################################

c       #############################################################

	subroutine BakerFidelity(VE,NN,iter,gam,idum,channel,alpha,
     1                           Fid2,Nsteps)
	implicit none

	integer NN,iter,idum,channel,dimA,i,j
	real*8 gam
c       State vector variables:
	complex*8 VE(0:2**NN-1),VE2(0:2**NN-1)

	complex*8 alpha(0:2**(NN)-1) !initial values

c       Fidelity
	real*8 Fid2
	complex*8 Fid2au

c       Baker variables
	integer steps,Nsteps
	   

        dimA=2**NN-1

c       ------------------------------------------------------	
c       Baker and inverse Baker algorithm
c       ------------------------------------------------------	
c       Baker

	   do steps=1, Nsteps
	      call QFTD(VE,NN,1,0,iter,gam,idum,channel)
	      call reorden(VE,VE2,NN,1)
	      call QFTD(VE2,NN,0,1,iter,gam,idum,channel)
	      call reorden(VE2,VE,NN,0)
	   end do !steps
c       ------------------------------------------------------	
c       ------------------------------------------------------	
c       Inverse Baker

	   do steps=1, Nsteps
	      call QFTD(VE,NN,0,0,iter,gam,idum,channel)
	      call reorden(VE,VE2,NN,0)
	      call QFTD(VE2,NN,1,1,iter,gam,idum,channel)
	      call reorden(VE2,VE,NN,1)
	   end do !steps
c       ------------------------------------------------------	



c       ------------------------------------------------------	
c	Fidelity
c       ------------------------------------------------------	

c       Initial state vector -> Bell pair + noise: 

	   do i=0, dimA
	    VE2(i)=(0.,0.)
	   end do !i

c          Random total (option 3)
	   do i=0, 2**NN-1
	      VE2(i)=alpha(i)
	   end do !i

	   Fid2au=0.
	   do i=0, 2**NN-1
	    Fid2au=Fid2au+conjg(VE(i))*VE2(i)
	   end do !i
	   Fid2=conjg(Fid2au)*Fid2au

c       -----------------------------------------------------	
c       Fidelity
c       -----------------------------------------------------	

	return
	end

c       subroutine ends here.//

c       #############################################################

c       #############################################################

	subroutine QFTD(VE,NN,laux,inv,iter,gam,idum,channel) 
	implicit none
	
	integer i,j,NN,l,laux,inv,iter,idum,channel
	real*8 gam
	complex*8 VE(0:2**NN-1)

c       Series of gates for the Quantum Fourier Transform 
c       with dissipative steps among them.//
c       Relabelling done separately, suitable for other  
c       environment models or algorithms.//


c       Description of I/O variables: 
c       -VE: state vector before and after QFTD
c       -NN: number of system's qubits
c       -laux: value "0" performs QFT for the full system 
c       and value "1" does it for all but the most 
c       significant bit
c       -inv: value "0" performs direct QFT and 
c       value "1" the inverse one.
c       >>From now on variables that control the dissipative step
c       -iter: discretization level of ops. 
c       -gam: coupling constant
c       -idum: random seed.
c       -channel: encoding of the selected channel

	l=NN-laux

	do i=1,l
	   do j=1, i-1
	      call gateBkl(VE,NN,l-i,l-j,inv)
	      call distep(VE,NN,gam,iter,idum,channel)
	   end do !j
	   call gateAk(VE,NN,l-i)
	   call distep(VE,NN,gam,iter,idum,channel)
	end do !i
	
	return
	end

c       subroutine ends here.//

c       #############################################################

c       #############################################################

	subroutine gateAk(VE,NN,k)
	implicit none

	integer NN,k
	integer j0,j1,i
	complex*8 VE(0:2**NN-1),aux1


c       Action of the Hadamard gate over comp. basis.//

	  do i=0, 2**(NN-1)-1

	     j0=(i/2**k)*2**(k+1)+i-(i/2**k)*2**k
	     j1=j0+2**k

	     aux1=1./dsqrt(2.d0)*(VE(j0)-VE(j1))
	     VE(j0)=1./dsqrt(2.d0)*(VE(j0)+VE(j1))
	     VE(j1)=aux1

	  end do !i

	  return
	  end 

c       subroutine ends here.//

c       #############################################################

c       #############################################################

	subroutine gateBkl(VE,NN,k,l,inv)
	implicit none

	integer NN,dimA,k,l,inv
	integer j0,j1,j2,i


	real*8 pi
	complex*8 VE(0:2**NN-1),aux1

c       Action of C-phase shift over comp. basis.// 
c       Always k<l.//   

	pi=2.d0*dasin(1.d0)

	 do i=0, 2**(NN-2)-1

	  j0=(i/2**(l-1))*2**(l+1)
	  j1=((i/2**k)-(i/2**(l-1))*2**(l-1-k))*2**(k+1)
	  j2=i-(i/2**k)*2**k

	  j0=j0+2**k+j1+2**l+j2

	  aux1=cmplx(dcos(pi/2**(l-k)),(-1.)**inv*dsin(pi/2**(l-k)))
	  VE(j0)=VE(j0)*aux1

	 end do !i

	return
	end 

c       subroutine ends here.//

c       #############################################################

c       #############################################################

	subroutine reorden(VE,VE2,NN,laux) 
	implicit none

	integer i,ir,irs,NN,laux
	complex*8 VE(0:2**NN-1),VE2(0:2**NN-1)

c       Relabelling of basis elements (alternatively coefs) 
c       according to bit reversal (for QFT(D)).//

	do i=0,2**(NN-laux)-1
	   irs=ir(i,NN-laux)
	   VE2(irs)=VE(i)
	   VE2(irs+laux*2**(NN-1))=VE(i+laux*2**(NN-1))
	end do !i

	return
	end

c       subroutine ends here.//

c       #############################################################

c       #############################################################

	function ir(i,NN)

c       reverses the bits of i

	ir=0
	do kk=1,NN
           call mvbits(i,kk-1,1,ir,NN-kk)
	end do			

	return
	end

c       function ends here.//

c       #############################################################

c       #############################################################

	subroutine distep(VE,NN,gam,iter,idum,channel)
	implicit none

	integer i,j,jj,iter,k,NN,dimA,channel,channelNr
	integer labord(0:3*NN),labm !probability handling
	integer init
	real*8 gam,norma
	real*8 dp,dpm !probabilidad de salto
	real*8 dpv(0:3*NN) !probs de cada canal (c/op K)
	complex*8 VE(0:2**NN-1),VEtemp, VE2(0:2**NN-1)

c       Random Numbers from NRs.
	integer idum
	real*8 eps 
	real ran1

c       "Binaries"
	integer ibbin(1000) 
	integer msum,bsum


c       This is the Quantum Trajectories subroutine.//
c       It is prepared to handle 6 channels of noise. 

c       Variables and channel codes: 
c	-VE: state vector 
c       -NN: number of qubits
c       -gam: coupling constant
c       -iter: number of steps in dissipation
c       -idum: dummy variable for random numbers
c       -channel: dissipative channel, where: 
c        0 : treshold model for amplitude damping
c        1 : statistical model for amp. damping
c        2 : Bit flip
c        3 : Both
c        4 : Phase flip
c        5 : Previuos three together




	dimA=2**NN-1

	if (channel.le.1) then
	channelNr=NN
	else
	   if (channel.eq.5) then
	      channelNr=3*NN
	   else
	      channelNr=NN
	   end if
	end if



c       Iterations begin here
c       ---------------------


 	do jj=1, iter 


c       Jump probability evaluation 
c       ---------------------------


	if (channel.le.1) then

c       Amplitude damping channels

	do k=0, NN-1

c       - - - - - - - - - - - - - - - - - - - - - - -
	call ampdamp2a(VE,VEtemp,NN,dimA,k,channel)
c       - - - - - - - - - - - - - - - - - - - - - - -

	dp=VEtemp/float(iter)
	dpv(k+1)=gam*dp 

	end do !k

	else

c       Depolarization channels

	do k=0, NN-1

	   if (channel.eq.5) then
	   do j=0, 2
	      
	dp=1.d0/float(iter)      
	dpv(1+k*3+j)=gam*dp 

	   end do !j

	   else

	   j=channel-2

	dp=1.d0/float(iter)      
	dpv(1+k)=gam*dp 

	   end if

	end do !k

	end if


c       Channels joint probability (#1 jump):

	dp=0.
	do k=1, channelNr 
	   dp=dp+dpv(k)
	end do !k


c       Random numbers -> eps
c	---------------------
	eps=ran1(idum)


c       Evolution (jump or H_eff)
c       -------------------------

	if (eps.lt.dp) then

c       Jump
c       ----


c       channel selection
	   j=1
	   dpm=dpv(j)
	   do while(eps.gt.dpm.and.j.lt.channelNr)
	      j=j+1
	      dpm=dpm+dpv(j)
	   end do !while


	   j=j-1 !just a relabelling

c       - - - - - - - - - - - - - - - - - - - - - - - -
	   if (channel.le.1) then
	       call ampdamp2b(VE,VE2,NN,dimA,j,channel)
	   else
	      if (channel.eq.5) then
	       call depolarization2b(VE,VE2,NN,dimA,
     1	       (j-mod(j,3))/3,mod(j,3))
	      else
	       call depolarization2b(VE,VE2,NN,dimA,
     1	       j,channel-2)
	      end if
	   end if
c       - - - - - - - - - - - - - - - - - - - - - - - -

c       Norm adjusting

	   norma=0.d0
	   do i=0, dimA
	      norma=norma+conjg(VE2(i))*VE2(i)	     
	   end do !i
	   norma=dsqrt(norma)

	   do i=0, dimA
	      VE(i)=VE2(i)/norma 
	   end do !i


c       Jump done
c       ---------

	   else

c       H_eff evolution
c       ---------------

cc	do j=1, iter 

	   do i=0, dimA
	      VE2(i)=0.
	   end do !i

	   if (channel.le.1) then
	    VE2(0)=VE(0) 
	    init=1
	   else
	    init=0
	   end if

	   do i=init, dimA 

	      if (channel.le.1) then

	       if (channel.eq.1) then
 	        call binario(i,ibbin,NN)
                       bsum=0
                       do msum=1,NN
                          bsum=bsum+ibbin(msum)
                       end do !msum 
	      VE2(i)=(1.d0-(gam/2.d0/float(iter)
     1               *float(bsum)))*VE(i)
	       else
	      VE2(i)=(1.d0-(gam/2.d0/float(iter)
     1               ))*VE(i)		 
	       end if

	      else

	      VE2(i)=(1.d0-(gam/2.d0/float(iter)
     1               *float(channelNr)))*VE(i) 

	      end if

	   end do !i


c       Norm adjusting

	   norma=0.d0
	   do i=0, dimA
	      norma=norma+conjg(VE2(i))*VE2(i)
	   end do !i
	   norma=dsqrt(norma)

	   do i=0, dimA
	      VE(i)=VE2(i)/norma
	   end do !i

c       H_eff evolution done
c       --------------------

	end if

	end do !jj  


	return
	end

c       subroutine ends here.//

c       #############################################################

c       #############################################################

	subroutine ampdamp2a(VE,VEtemp,NN,dimA,k,channel)
	implicit none

	integer NN,dimA,k,channel
	integer i2,j2,m,b,i,j
	integer ibbin(1000)
	complex*8 VE(0:dimA),VEtemp,aux1

	VEtemp=0.
	
	  do j2=0, 2**(NN-1)-1

	     j=j2/2**k*2**(k+1)+2**k+j2-j2/2**k*2**k
	     i=j-2**k

	     if (i.eq.0) then 
		VEtemp=VEtemp+conjg(VE(j))*VE(j)
	     else
	      if (channel.eq.0) then
	        call binario(j,ibbin,NN)
                       b=0
                       do m=1,NN
                          b=b+ibbin(m)
                       end do !m
		aux1=conjg(cmplx(sqrt(1./dfloat(b)),0.)*VE(j))
		aux1=aux1*cmplx(sqrt(1./dfloat(b)),0.)*VE(j)
	      else
		aux1=conjg(VE(j))*VE(j) !AD2 - statistical model
	      end if
		VEtemp=VEtemp+aux1
             end if

	  end do !j2


	  return
	  end 

c       subroutine ends here.//

c	#############################################################

c       #############################################################

	subroutine ampdamp2b(VE,VE2,NN,dimA,k,channel)
	implicit none

	integer NN,dimA,k,channel
	integer i2,j2,m,b,i,j
	integer ibbin(1000)
	complex*8 VE(0:dimA),VE2(0:dimA)

c       Performs product L_mu |psi> (element i2)  amp damping.//

	do j2=0, dimA
	   VE2(j2)=0.d0
	end do !j2
	
	  do j2=0, 2**(NN-1)-1

	     j=j2/2**k*2**(k+1)+2**k+j2-j2/2**k*2**k
	     i=j-2**k

	     if (i.eq.0) then 

		VE2(i)=VE(j)

	     else

	      if (channel.eq.0) then
	        call binario(j,ibbin,NN)
                       b=0
                       do m=1,NN
                          b=b+ibbin(m)
                       end do !m
		VE2(i)=cmplx(sqrt(1./dfloat(b)),0.)*VE(j)
	      else
		VE2(i)=VE(j)	!AD2 - statistical model
	      end if

            end if

	  end do !j2


	  return
	  end 

c       subroutine ends here.//
	
c	#############################################################

c       #############################################################

	subroutine depolarization2b(VE,VE2,NN,dimA,k,j)	   
	implicit none

	integer NN,dimA,k
	integer i,j,i2,j2
	complex*8 VE(0:dimA),VE2(0:dimA),aux1

c       Calculates product L_mu |psi> depolarization.//

c       ->Bit-flip channel<-

	if (j.eq.0) then

	   do i=0, 2**(NN-1)-1

	      i2=(i/2**k)*2**(k+1)+i-(i/2**k)*2**k
	      j2=i2+2**k
	      VE2(i2)=VE(j2)

	      j2=i2
	      i2=i2+2**k
	      VE2(i2)=VE(j2)

	   end do !i

	end if

c       ->Both channels<-

	if (j.eq.1) then
	
	   do i=0, 2**(NN-1)-1

	      i2=(i/2**k)*2**(k+1)+i-(i/2**k)*2**k
	      j2=i2+2**k
	      VE2(i2)=(0.,-1.)*VE(j2)

	      j2=i2
	      i2=i2+2**k
	      VE2(i2)=(0.,1.)*VE(j2)
	      
	   end do !i
	
	end if

c       ->Phase flip/damping channel<-

	if (j.eq.2) then
	
	   do i=0, 2**(NN-1)-1

	      i2=(i/2**k)*2**(k+1)+i-(i/2**k)*2**k
	      VE2(i2)=VE(i2)

	      i2=i2+2**k
	      VE2(i2)=-1.*VE(i2)
	      
	   end do !i
	
	end if

	return
	end

c       subroutine ends here.//	
	
c	#############################################################

c	#############################################################

	subroutine FSWAP(VE,NN,m,n)
	implicit none

c       Constructs the swap operator between the mth and nth qubits. 

c       Parameters
	integer NN !Number of qubits

c       Calculation variables
	integer i,j
	integer m,n
	complex*8 VE(0:2**NN-1),VEtemp


	do i=0, 2**(NN-2)-1
	 j=(i/2**(n-1))*3*2**(n-1)+i
	 VEtemp=VE(j+2**m)
	 VE(j+2**m)=VE(j+2**n)
	 VE(j+2**n)=VEtemp
	end do !i

	return
	end

c       subroutine ends here.//

c       #############################################################

c       #############################################################

	Function ran1(idum)
	integer idum,IA,IM,IQ,IR,NTAB,NDIV
	real ran1,AM,EPS,RNMX
	parameter (IA=16807,IM=2147483647,AM=1./IM,IQ=127773,IR=2836)
	parameter (NTAB=32,NDIV=1+(IM-1)/NTAB,EPS=1.2e-7,RNMX=1.-EPS)

	integer j,k,iv(NTAB),iy
	save iv,iy
	data iv /NTAB*0/, iy /0/

c       Calculates pseudorandom numbers, fast (source: NR).
      
	if (idum.le.0.or.iy.eq.0) then
         idum=max(-idum,1)
         do j=NTAB+8,1,-1
            k=idum/IQ
            idum=IA*(idum-k*IQ)-IR*k
            if (idum.lt.0) idum=idum+IM
            if (j.le.NTAB) iv(j)=idum
         end do !j
         iy=iv(1)
	end if
	k=idum/IQ
	idum=IA*(idum-k*IQ)-IR*k
	if (idum.lt.0) idum=idum+IM
	j=1+iy/NDIV
	iy=iv(j)
	iv(j)=idum
	ran1=min(AM*iy,RNMX)

	return 
	end

c       function ends here.//

c       #############################################################

c       #############################################################

        subroutine binario(nu,ibbin,k)
        implicit none

c       Gives the binary code corresponding to integer "nu".//
c       Calls binary.//

        integer k,ibbin(1000),nu

        call binary(nu,k,ibbin)

        end

        subroutine binary(nu,k,ibbin)
        dimension ibbin(k)

        do i=1,k
c         ibbin(i)=ibits(nu,k-i,1) !binary code from most significant
          ibbin(i)=ibits(nu,i-1,1) !binary code from less significant
        end do

        return
        end

c       subroutine(s 2) end(s) here.//

c	#############################################################

c       #############################################################

	subroutine Pdir(A,B,C,M1,N1)
	implicit none

c       Performs direct product A times B allocating the result in C.
c       dims of matrices:A->N1+1,B->M1+1,C->(N1+1)*(M1+1)

	integer i,j,k,l,N1,M1
	complex*8 A(0:7,0:7)
	complex*8 B(0:7,0:7),C(0:7,0:7)

	do i=0, N1
	   do j=0, N1
	      do k=0, M1
		 do l=0, M1
		    C(i*M1+i+k,j*M1+j+l)=A(i,j)*B(k,l)
		 end do !l
	      end do !k
	   end do !j
	end do !i

	return
	end

c	subroutine ends here.//

c	#############################################################

c       #############################################################

	subroutine PTraceV(VE,NN,RHOr,s1,s2)
	implicit none

c       Performs partial trace of density matrix VEp -> RHOr
c       s1 (spin 1) is always greater than s2 (spin 2)

	integer NN
	integer k,l,m,mp,s1,s2,as1,as2,bs1,bs2
	complex*8 VE(0:2**NN-1),RHOr(0:7,0:7)


	do k=0, 3
	   as2=mod(k,2)
	   as1=k/2
	   do l=0, 3
	      bs2=mod(l,2)
	      bs1=l/2
	      RHOr(k,l)=0.
	      do mp=0, 2**(NN-2)-1
c              mp -> m
	       m=mp/2**(s1-1)*2**(s1+1)
	       m=m+(mp/2**s2-mp/2**(s1-1)*
     1           2**(s1-1-s2))*2**(s2+1)
	       m=m+mp-mp/2**s2*2**s2
	        RHOr(k,l)=RHOr(k,l)+
     1    VE(m+as1*2**s1+as2*2**s2)*conjg(VE(m+bs1*2**s1+bs2*2**s2))
	      end do !mp
	   end do !l
	end do !k

	return
	end

c	subroutine ends here.//

c	#############################################################

c       #############################################################

	subroutine Mmult(A,B,C,M1)
	implicit none

c       Performs dot product A times B (result in C). 
c       dimension of matrices: M1 (square).

	integer i,j,k,M1
	complex*8 A(0:7,0:7),B(0:7,0:7),C(0:7,0:7)

	do i=0, M1
	   do j=0, M1
	      C(i,j)=0.d0
	   end do !j
	end do !i

	do i=0, M1
	   do j=0, M1
	      do k=0, M1
		 C(i,j)=C(i,j)+A(i,k)*B(k,j)
	      end do !k
	   end do !j
	end do !i

	return
	end

c	subroutine ends here.//

c	#############################################################







