C
C     PROGRAM SIMULATING THE EVOLUTION OF THE QUANTUM SAWTOOTH MAP
C     AS IN A (NOISY) QUANTUM COMPUTER 
C
C     Average all quantities over nmed
C


C     PROGRAM VARIABLES

C     ntot= number of map steps
C     nq = number of qubits
C     b= matrix for the binary encoding of the basis
C     psi= wave function
C     T= fattore a moltiplicare il calcio prop. a teta**2
C     con1= set it to 1 to see the Fourier transform in the file trasf.dat
C     nrum1=number of noise configurations for averaging


      PROGRAM SAWMAP_con_QC_rumoroso

      implicit real*8 (a-h,p-z)

      include "nqbit.in"        ! parameter (nq= numero qubits)
      
      integer a(nq,2**nq),r1(nq),p,q,pan,filtro,con1,filtro1,
     c     conf,chconf,gates
      real*8 max,psi0(2,2**nq),psi(2,2**nq),k,kc,ipr,eps(18),ep(18)
      real*8 fidmed(0:100000),iprmed(100000),varmed(100000),
     c     psian(4,2**nq)
      character*30 file2,file3,file4,file5
      
      common /gen/ a,psi,r1
      common /npar/ pi
      common /preci/ prec
      common /analisi/ psi0
      common /g/ gates
      common /random/ eps,epsi,pan,kick
      common /porte/ ep,conf

C     INITIAL DECLARATIONS

      pi=4d0*datan(1d0)

      open(unit=2,file='sawmap.in',status='unknown')

      read (2,*) ntot
      read(2,*) emme
      T=4*pi/2**nq*emme

      read (2,*) kc
      k=-kc/T    

      print *, 'quantum kicking strength k= ', -k
      print *, ''
      read (2,*) nin
      n0in=2**(nq-1)+nin
      dn=sqrt(2**nq/(2*pi*2*emme))

      read (2,*) nmed           ! average over 2*nmed+1 states

      read (2,*) epsi
      read (2,*) conf
      read (2,*) nrum1          ! average over nrum1 noise configurations

      read (2,*) file2
      open (unit=66,file=file2)
      read (2,*) file3
      open (unit=1,file=file3)
      read (2,*) file4
      open (unit=11,file=file4)
      read (2,*) file5
c      open (unit=77,file=file5)

      con1=0
      pan=-100
      prec=1d-14

c     Register initialization
      Do 10 i=1,nq
         r1(i)=i
 10   CONTINUE

      DO 11 i=1,ntot
         fidmed(i)=0d0
c         varmed(i)=0d0
c         iprmed(i)=0d0
 11   CONTINUE

C     END OF INITIAL DECLARATIONS

c
c     Subroutine building the binary basis
c

      call base
      call costruisci(nq)

      i=0
      fidmed(0)=1.d0
      write (66,*) i,fidmed(0)     

C     TIME EVOLUTION

      DO 190 ijrum=1,nrum1 ! repeat time evolution over all noise configurations

         PRINT *,'NOISE CONFIGURATION NUMBER ',ijrum
         call inizializzo

         DO 150 iuj=-nmed,nmed

            PRINT *, 'STATE NUMBER ',iuj

            Do 100 i=1,ntot     ! integrate over (discrete) time
               
               do 95 kick=1,2
                  gates=0
                  IF (i.ne.1) THEN 
                     DO 34 ii=1,2**nq
                        IF (kick.eq.1) THEN
                           psi(1,ii)=psian(1,ii)
                           psi(2,ii)=psian(2,ii)
                        ELSE
                           psi(1,ii)=psian(3,ii)
                           psi(2,ii)=psian(4,ii)
                        ENDIF
 34                  CONTINUE

                  ELSE
                     nnin=n0in+iuj*dn
                     xxin=iuj*dn
                     prob=0
                     do ii=1,2**nq
                        psi(1,ii)=exp(-(ii-nnin)**2/(2*dn**2))
                        psi(2,ii)=-(ii-nnin)*xxin
                        prob=prob+exp(-(ii-nnin)**2/dn**2)
                     end do
                     do ii=1,2**nq
                        psi(1,ii)=psi(1,ii)/sqrt(prob)
                     enddo
                  ENDIF

C     EVOLUTION OF THE DYNAMICAL SYSTEM
                  if (kick.eq.1) then
                     do j=1,18
                        ep(j)=0
                     enddo
                     call evlib(T)
                     call QFT(con1)
                     call teta2(k)
                     call QFTINV
                  else
                     do j=1,18
                        ep(j)=eps(j)
                     enddo
                     call evlib(T)
                     call QFT(con1)
                     call teta2(k)
                     call QFTINV
                  endif
C     END EVOLUTION OF THE DYNAMICAL SYSTEM

c      call ordina

                  IF (kick.eq.1) THEN ! without perturbation
                     DO 66 ii=1,2**nq
                        psian(1,ii)=psi(1,ii)
                        psian(2,ii)=psi(2,ii)
 66                  CONTINUE
                  ELSE          ! with perturbation
                     DO 67 ii=1,2**nq
                        psian(3,ii)=psi(1,ii)
                        psian(4,ii)=psi(2,ii)
                        psi0(1,ii)=psian(1,ii)
                        psi0(2,ii)=psian(2,ii)
 67                  CONTINUE
                     call fidelity(fido)
c                     call varianza(var,ipr)
                     fidmed(i)=fidmed(i)+fido
c                     iprmed(i)=iprmed(i)+ipr
c                     varmed(i)=varmed(i)+var
                  endif
 95            continue
 100        CONTINUE            ! end integration over (discrete) time

C     Write output
            
            IF ((iuj.eq.0).and.(ijrum.eq.1)) THEN
               so=0
               so1=0
               DO 140 i=1,2**nq
                  so=so+psi(1,i)**2
                  so1=so1+psian(3,i)**2
                  write (11,fmt=201) i-2**(nq-1),psian(3,i)**2,
     #                 psian(4,i)
                  write (1,fmt=201) i-2**(nq-1),psian(1,i)**2,
     #                 psian(2,i)
 140           CONTINUE
            ENDIF

 150     CONTINUE               ! end average over state

 190  CONTINUE                  ! end average over noise configurations
      
 201  format (i10,tr1,2f20.15)
      print *, ''
      print *, 'SUM OF SQUARE MODULI:'
      print 202, so,so1
 202  format (f20.15)
      
      print *, 'Number of states and noise configurations'
      print *, 'for avaraging: ',2*nmed+1,nrum1
      print *,''

      DO 300 i=1,ntot
         write (66,*) i,fidmed(i)/((2*nmed+1)*nrum1)        
c         write (77,*) i,iprmed(i)/((2*nmed+1)*nrum1),varmed(i)/((2*
c     c        nmed+1)*nrum1)
 300  CONTINUE

      print *, 'Number of elementary quantum gates per kicks:'
      print *, gates

      stop
      end



CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C      MAIN SUBROUTINES                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

C Generates a basis of n spins and put it in a 
      SUBROUTINE BASE

      include "nqbit.in"

      integer a(nq,2**nq),r1(nq),p,q
      real*8 psi(2,2**nq)
      common /gen/ a,psi,r1

      DO 20 i=1,nq
         p=0
         DO 10 j=1,2**nq
            IF (p.lt.2**(i-1)) THEN
               a(i,j)=+1
               p=p+1
               q=0
            ELSE
               a(i,j)=0
               p=p+1
               q=q+1
               IF (q.ge.2**(i-1)) THEN
                  p=0
               ENDIF
            ENDIF
 10      CONTINUE
 20   CONTINUE

      return
      end      


C Subroutine for the quantum Fourier transform
      SUBROUTINE QFT(con1)

      include "nqbit.in"

      integer con1,r1(nq),b(nq,2**nq),gates
      real*8 psi(2,2**nq)
      common /gen/ b,psi,r1
      common /g/ gates

      DO 100 i=0,nq-1
         k=nq-i
         DO 50 j=k,nq-1
            kk=nq+k-j
            call accosta(k,kk)
            call gateB(k,kk)
            gates=gates+1
 50      CONTINUE
         call gateA(k,0)
         gates=gates+1
 100  CONTINUE

      call reversi

      IF (con1.eq.1) THEN
         print *, 'TRANSFORM'
         
         open (unit=23, file='trainsf.dat')

         Do 110 i=1,2**nq
            print 109, i,psi(1,i),psi(2,i)
            write (23,fmt=109) i,psi(1,i),psi(2,i)
 109        format (i5,tr1,2f20.15)
 110     CONTINUE
      ENDIF
      return
      end


C Subroutine for free evolution
      SUBROUTINE Evlib(T)      

      include "nqbit.in"

      integer r1(nq),b(nq,2**nq),gates
      real*8 psi(2,2**nq),T
      common /gen/ b,psi,r1
      common /g/ gates

      DO 150 i=2,nq
         DO 100 j=1,i-1
               call accosta(i,j)
               call gateN(i,j,T)
               call gateN(j,i,T)
               gates=gates+2
 100     CONTINUE
 150  CONTINUE

      DO 210 i=1,nq
         call gateN(i,i,T)
         gates=gates+1
 210  CONTINUE

      return
      end


C Subroutine for the kick
      SUBROUTINE TETA2(k)      

      include "nqbit.in"

      integer r1(nq),b(nq,2**nq),gates
      real*8 psi(2,2**nq),k 
      common /gen/ b,psi,r1
      common /g/ gates

      DO 150 i=2,nq
         DO 100 j=1,i-1
            call accosta(i,j)
            call gateT(i,j,k)
            call gateT(j,i,k)
            gates=gates+2
 100     CONTINUE
 150  CONTINUE

      DO 200 i=1,nq
         call gateT(i,i,k)
         gates=gates+1
 200  CONTINUE

      return
      end


C Subroutine for inverse QFT
      SUBROUTINE QFTINV
      
      include "nqbit.in"      

      integer r1(nq),b(nq,2**nq),gates
      real*8 psi(2,2**nq)
      common /gen/ b,psi,r1
      common /g/ gates

      call reversi

      DO 30 i=0,nq-1
         k=i+1
         call gateA(k,0)
         gates=gates+1
         DO 10 j=1+i,nq-1
            kk=j+1
            call accosta(k,kk)
            call gateBC(k,kk)
            gates=gates+1
 10      CONTINUE
 30   CONTINUE

      return
      end


C     This subroutine swaps spins i and j to nearby positions
c     (useless in the present shape of the code, can be used 
c     for further studies)
      SUBROUTINE ACCOSTA(i,j)

      include "nqbit.in"

      integer r(nq),b(nq,2**nq),cord(2,2),fis(2)
      real*8 psi(2,2**nq) 

      common /reg/l,m
      common /gen/ b,psi,r

CC    Compute the true position of spins
c      DO 11 k=1,nq
c         IF (r(k).eq.i) THEN
c            fis(1)=k
c         ENDIF
c         IF (r(k).eq.j) THEN
c            fis(2)=k
c         ENDIF
c 11   CONTINUE
      
CC     Compute coordinates of bits in the grid l*m
      
c      DO 21 k=1,2
c         cord(k,1)=mod(fis(k)-1,l)+1
c         cord(k,2)=(fis(k)-cord(k,1))/l+1
c 21   CONTINUE
CC     Compute number of swaps
c      nx=abs(cord(1,1)-cord(2,1))
c      ny=abs(cord(1,2)-cord(2,2))

CC     discard cases for which swap gates are not necessary
c      IF ((nx.eq.1).and.(ny.eq.0)) THEN
c         goto 1000
c      ENDIF
c      IF ((nx.eq.0).and.(ny.eq.1)) THEN
c         goto 1000
c      ENDIF

CC     Exchanges along Y

c      IF (cord(2,2)-cord(1,2).gt.0) THEN
c         DO 31 kk=1,ny
c            call swap(fis(2),fis(2)-l,1)
c            fis(2)=fis(2)-l
c 31      CONTINUE
c      ELSE
c         DO 36 kk=1,ny
c            call swap(fis(2)+l,fis(2),1)
c            fis(2)=fis(2)+l
c 36      CONTINUE
c      ENDIF
      
CC     Exchanges along X

c      IF (cord(2,1)-cord(1,1).gt.0) THEN
c         DO 41 kk=1,nx-1
c            call swap(fis(2),fis(2)-1,1)
c            fis(2)=fis(2)-1
c 41      CONTINUE
c      ELSE
c         DO 46 kk=1,nx-1
c            call swap(fis(2)+1,fis(2),1)
c            fis(2)=fis(2)+1
c 46      CONTINUE
c      ENDIF

c 1000 continue
      return
      end


C     Exchange the coefficients of the wave vector (in-1, fin=0 to
c     in=0, fin=1)
      SUBROUTINE SWAP(in,fin,sca)

      include "nqbit.in"
      
      integer fin,b(nq,2**nq),r1(nq),lab(nq),sca,gates
      real*8 psi(2,2**nq),temp(2),sigz(2**nq)
      common /gen/ b,psi,r1
      common /rum/ sigz
      common /g/ gates

      DO 50 i=1,2**nq
C     Find lines to exchange
         IF (b(in,i).eq.1) THEN
            IF (b(fin,i).eq.0) THEN
               DO 10 k=1,nq
                  lab(k)=k
 10            CONTINUE
               lab(fin)=in
               lab(in)=fin
               num=0
               DO 20 ll=1,nq
                  num=b(ll,i)*2**(lab(ll)-1)+num
 20            CONTINUE
               num=2**nq-num
C     Exchange coefficients of the wave function
               DO 30 kk=1,2
                  temp(kk)=psi(kk,i)
                  psi(kk,i)=psi(kk,num)
                  psi(kk,num)=temp(kk)
 30            CONTINUE
            ENDIF
         ENDIF
 50   CONTINUE
      IF (sca.eq.1) THEN
         nn=r1(in)
         r1(in)=r1(fin)
         r1(fin)=nn
      ENDIF
      gates=gates+3
      return
      end


C     Subroutine computing the diagonal quantum gate 1,1,1,
c     exp(i pi/2**(j-i)). The two qubits must be nearby
      SUBROUTINE gateB(i,j)

      include "nqbit.in"

      integer b(nq,2**nq),r1(nq),fisi,fisj,s,conf
      real*8 psi(2,2**nq),pi,uno,ep(18)
      common /npar/ pi
      common /gen/ b,psi,r1
      common /porte/ ep,conf

      if (conf.eq.1) then
         call inizializzo
      endif

      DO 10 k=1,nq
         IF (r1(k).eq.i) THEN
            fisi=k
         ENDIF
         IF (r1(k).eq.j) THEN
            fisj=k
         ENDIF
 10   CONTINUE
      
      DO 20 k=1,2**nq
         s=b(fisi,k)+b(fisj,k)  
         IF (s.eq.2) THEN
            IF (psi(1,k).ne.0) THEN
               psi(2,k)=psi(2,k)+pi/(2d0)**(j-i)+ep(4)
               call periodo(psi(2,k))
            ENDIF
         ENDIF
         IF (s.eq.0) THEN
            IF (psi(1,k).ne.0) THEN
               psi(2,k)=psi(2,k)+ep(1)
               call periodo(psi(2,k))
            ENDIF
         ENDIF
         IF (s.eq.1) THEN
            IF (psi(1,k).ne.0) THEN
               if (b(fisi,k).eq.1) then
                  psi(2,k)=psi(2,k)+ep(3)
                  call periodo(psi(2,k))
               else
                  psi(2,k)=psi(2,k)+ep(2)
                  call periodo(psi(2,k))
               endif
            ENDIF
         ENDIF
 20   CONTINUE

      return
      end


C     Subroutine computing the Hadamard gate
C     | 1  1 |
C     |      | * 1/SQRT(2)
C     | 1 -1 |
C     con=0 bit of information, otherwise physical bit
      SUBROUTINE gateA(i,con)

      include "nqbit.in"

      implicit real*8 (a-h,p-z)
      integer b(nq,2**nq),r1(nq),fisi,lab(nq),a(nq),con,conf
      real*8 psi(2,2**nq),invr2,ep(18)
      common /npar/ pi
      common /gen/ b,psi,r1
      common /porte/ ep,conf

      if (conf.eq.1) then
         call inizializzo
      endif
      invr2=1d0/dsqrt(2d0)
      
      IF (con.eq.0) THEN
         DO 10 k=1,nq
            IF (r1(k).eq.i) THEN
               fisi=k
            ENDIF
 10      CONTINUE
      ELSE
         fisi=i
      ENDIF

      DO 50 k=1,2**nq
         IF (b(fisi,k).eq.1) THEN
            DO 20 kk=1,nq
               lab(kk)=kk
 20         CONTINUE
            DO 25 kk=1,nq
               IF (kk.ne.fisi) THEN
                  a(kk)=b(kk,k)
               ELSE
                  a(kk)=0
               ENDIF
 25         CONTINUE
            num=0
c     Compute the row for exchange
            DO 30 ll=1,nq
               num=a(ll)*2**(lab(ll)-1)+num
 30         CONTINUE
            num=2**nq-num

c     Compute the new coefficient
            IF ((psi(1,k).eq.0).and.(psi(1,num).eq.0)) THEN
            ELSE  

               if (invr2*(cos(ep(5))+sin(ep(5))).ge.0) then
                  a1=invr2*(cos(ep(5))+sin(ep(5)))*psi(1,k)
                  a3=invr2*(cos(ep(5))+sin(ep(5)))*psi(1,num)
                  t1=psi(2,k)+ep(6)
                  t3=psi(2,num)-ep(6)
               else
                  a1=-invr2*(cos(ep(5))+sin(ep(5)))*psi(1,k)
                  a3=-invr2*(cos(ep(5))+sin(ep(5)))*psi(1,num)
                  t1=psi(2,k)+ep(6)+pi
                  t3=psi(2,num)-ep(6)+pi
               endif
               if (invr2*(cos(ep(5))-sin(ep(5))).ge.0) then
                  a2=invr2*(cos(ep(5))-sin(ep(5)))*psi(1,num)
                  a4=invr2*(cos(ep(5))-sin(ep(5)))*psi(1,k)
                  t2=psi(2,num)
                  t4=psi(2,k)+pi
               else
                  a2=-invr2*(cos(ep(5))-sin(ep(5)))*psi(1,num)
                  a4=-invr2*(cos(ep(5))-sin(ep(5)))*psi(1,k)
                  t2=psi(2,num)+pi
                  t4=psi(2,k)
               endif
               call csom(a1,a2,t1,t2,ro1,teta1)
               call csom(a3,a4,t3,t4,ro2,teta2)
               psi(2,k)=teta2
               psi(1,k)=ro2
               psi(2,num)=teta1
               psi(1,num)=ro1 
            ENDIF
         ENDIF
 50   CONTINUE
      return
      end


C     Subroutine computing the diagonal quantum gate 1,1,1,
c     exp(-i pi/2**(j-i)). The two qubits must be nearby.
c     This is the GATE B^dagger 
      SUBROUTINE gateBC(i,j)

      include "nqbit.in"

      integer b(nq,2**nq),r1(nq),fisi,fisj,conf
      real*8 psi(2,2**nq),pi,ep(18)
      common /npar/ pi
      common /gen/ b,psi,r1
      common /porte/ ep,conf

      if (conf.eq.1) then
         call inizializzo
      endif
      
      DO 10 k=1,nq
         IF (r1(k).eq.i) THEN
            fisi=k
         ENDIF
         IF (r1(k).eq.j) THEN
            fisj=k
         ENDIF
 10   CONTINUE

      DO 20 k=1,2**nq
         s=b(fisi,k)+b(fisj,k)         
         IF (s.eq.2) THEN
            IF (psi(1,k).ne.0) THEN
               psi(2,k)=psi(2,k)-pi/(2d0)**(j-i)+ep(10)
               call periodo(psi(2,k))
            ENDIF
         ENDIF
         IF (s.eq.0) THEN
            IF (psi(1,k).ne.0) THEN
               psi(2,k)=psi(2,k)+ep(7)
               call periodo(psi(2,k))
            ENDIF
         ENDIF
         IF (s.eq.1) THEN
            IF (psi(1,k).ne.0) THEN
               if (b(fisi,k).eq.1) then
                  psi(2,k)=psi(2,k)+ep(9)
                  call periodo(psi(2,k))
               else
                  psi(2,k)=psi(2,k)+ep(8)
                  call periodo(psi(2,k))
               endif
            ENDIF
         ENDIF
 20   CONTINUE

      return
      end


C Subroutine rearranging qubits at the end of the QFT
      SUBROUTINE Reversi
      
      include "nqbit.in"
    
      integer b(nq,2**nq),r1(nq),con,r2(nq),fisi,fine
      real*8 psi(2,2**nq),temp(2)
      common /gen/ b,psi,r1
      common /reg/ l,m
      
c      call ordina

      DO 1 k=1,nq
         r2(k)=r1(k)
 1    CONTINUE
      m3=0

 2    CONTINUE

      Do 100 i=1,nq
         DO 10 k=1,nq
            IF(r2(k).eq.i) THEN
               fisi=k
            ENDIF
            IF(r1(k).eq.nq-i+1) THEN
               fine=k
            ENDIF
 10      CONTINUE

         nfy=fisi*1d0/(l+1)
         niy=fine*1d0/(l+1)

         IF(nfy.eq.niy) THEN
            ny=0
         ELSE
            nfy=l*int(nfy)
            niy=l*int(niy)
            ny=(nfy-niy)/l
         ENDIF

         nx=fisi-ny*l-fine

         IF (ny.gt.0) THEN
            DO 20 j=1,ny
               nemp=r2(fisi-l)
               r2(fisi-l)=r2(fisi)
               r2(fisi)=nemp
               call swap(fisi,fisi-l,0)                  
               fisi=fisi-l
 20         CONTINUE
         ELSE
            DO 30 j=1,-ny
               nemp=r2(fisi)
               r2(fisi)=r2(fisi+l)
               r2(fisi+l)=nemp
               call swap(fisi,fisi+l,0)                  
               fisi=fisi+l
 30         CONTINUE
         ENDIF

       IF (nx.gt.0) THEN
            DO 40 j=1,nx
               nemp=r2(fisi)
               r2(fisi)=r2(fisi-1)
               r2(fisi-1)=nemp
               call swap(fisi,fisi-1,0)                  
               fisi=fisi-1
 40         CONTINUE
         ELSE
            DO 50 j=1,-nx
               nemp=r2(fisi)
               r2(fisi)=r2(fisi+1)
               r2(fisi++1)=nemp
               call swap(fisi,fisi+1,0)                  
               fisi=fisi+1
 50         CONTINUE
         ENDIF
 100  CONTINUE

      m1=0
      DO 120 i=1,nq
         m1=m1+abs(r2(i)-(nq-i+1))
 120  CONTINUE

      IF (m3.gt.nq) THEN
         print *, 'ARIREVERSA'
      ENDIF
      IF (m1.gt.0) THEN
         m3=m3+1
         goto 2
      ENDIF

      return
      end


C     Subroutine computing the diagonal quantum gate
C     exp(-i*T/2*2**(2*(nq-1))/nq**2)
C     exp(-i*T/2*[2**(2*(nq-1))/nq**2-2**((nq-1)+i)/nq]
C     exp(-i*T/2*[2**(2*(nq-1))/nq**2-2**((nq-1)+j)/nq]
C     exp(-i*T/2*(2**(j)-2**(nq-1)/nq)*(2**(i)-2**(nq-1)/nq))
c     the two qubits must be nearby
      SUBROUTINE gateN(i,j,T)

      include "nqbit.in"

      integer b(nq,2**nq),r1(nq),fisi,fisj,conf
      real*8 psi(2,2**nq),T,ep(18)
      common /gen/ b,psi,r1
      common /porte/ ep,conf

      if (conf.eq.1) then
         call inizializzo
      endif

      DO 10 k=1,nq
         IF (r1(k).eq.i) THEN
            fisi=k
         ENDIF
         IF (r1(k).eq.j) THEN
            fisj=k
         ENDIF
 10   CONTINUE

      DO 20 k=1,2**nq
         IF (psi(1,k).ne.0) THEN
            IF (b(fisi,k).eq.0) THEN
               IF (b(fisj,k).eq.0) THEN
                  psi(2,k)=psi(2,k)-T/2*2d0**(2d0*(nq-1))/nq**2+ep(11)
               ELSE
                  psi(2,k)=psi(2,k)-T/2*(2d0**(2*(nq-1))/nq**2-2d0**((nq
     #                 -1)+(j-1))/nq)+ep(12)
               ENDIF
            ELSE
               IF (b(fisj,k).eq.0) THEN
                  psi(2,k)=psi(2,k)-T/2*(2d0**(2*(nq-1))/nq**2-2d0**((nq
     #                 -1)+(i-1))/nq)+ep(13)
               ELSE
                  psi(2,k)=psi(2,k)-T/2*(2d0**(j-1)-2d0**(nq-1)/nq)*
     #                 (2d0**(i-1)-2d0**(nq-1)/nq)+ep(14)
               ENDIF
            ENDIF
         ENDIF
 20   CONTINUE

      return
      end


C     Subroutine computing the diagonal quantum gate
C     exp(i*k*pi**2/(2*nq**2))
C     exp(i*k*pi/nq**2(2**(-i)-1/(2*nq)))
C     exp(i*k*pi/nq**2(2**(-j)-1/(2*nq)))
C     exp(i*k*pi**2(2**(-j)-1/(2*nq))*(2**(-i)-1/(2*nq)))
C     The two qubits must be nearby.
C     This subroutine implements the kicks \propto (teta-pi)**2.
      SUBROUTINE gateT(i,j,T)

      include "nqbit.in"

      integer b(nq,2**nq),r1(nq),fisi,fisj,conf
      real*8 psi(2,2**nq),T,pi,pi2,ep(18)
      common /npar/ pi
      common /gen/ b,psi,r1
      common /porte/ ep,conf

      if (conf.eq.1) then
         call inizializzo
      endif

      DO 10 k=1,nq
         IF (r1(k).eq.i) THEN
            fisi=k
         ENDIF
         IF (r1(k).eq.j) THEN
            fisj=k
         ENDIF
 10   CONTINUE

      pi2=pi**2

      DO 20 k=1,2**nq
         IF (psi(1,k).ne.0) THEN
            IF (b(fisi,k).eq.0) THEN
               IF (b(fisj,k).eq.0) THEN
                  psi(2,k)=psi(2,k)-pi2*T/(2*nq**2)+ep(15)
               ELSE
                  psi(2,k)=psi(2,k)+pi2*T/nq*(2d0**(j-1-nq)-1d0/(2*
     c                 nq))+ep(16)
               ENDIF
            ELSE
               IF (b(fisj,k).eq.0) THEN
                  psi(2,k)=psi(2,k)+pi2*T/nq*(2d0**(i-1-nq)-1d0/(2*
     c                 nq))+ep(17)
               ELSE
                  psi(2,k)=psi(2,k)-2*pi2*T*(2d0**(i-1-nq)-1d0/(2*nq))*
     #                 (2d0**(j-1-nq)-1d0/(2*nq))+ep(18)
               ENDIF
            ENDIF
         ENDIF

         call periodo(psi(2,k))
         
 20   CONTINUE

      return
      end



CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C    AUXILIARY SUBROUTINES                                       C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

C Sum of two complex numbers, ra e rb are their moduli,
C ta, tb their phases,  ro e teta modulus and phase of the sum.
C cutoff prec= 5*10^-15
      SUBROUTINE csom(ra,rb,ta,tb,ro,teta)
      
      implicit real*8 (a-h,p-z)
      common /npar/ pi
      common /preci/ prec

      zero=0d0
      aa=ra*dcos(ta)
      ab=rb*dcos(tb)
      ba=ra*dsin(ta)
      bb=rb*dsin(tb)
            
      sa=aa+ab
      sb=ba+bb

      ro=dsqrt((sa)**2+(sb)**2)

      IF (ro.lt.prec) THEN
         ro=zero
         teta=zero
         goto 1000
      ENDIF

      IF (ro.gt.0d0) THEN
         IF (sa.gt.zero) THEN
            IF (sb.ge.zero) THEN
               teta=datan(sb/sa)
            ELSE
               teta=1.5*pi+datan(sa/dabs(sb))
            ENDIF
         ELSE
            IF (sb.gt.zero) THEN
               teta=pi/2d0+datan(dabs(sa)/sb)
            ELSE
               teta=pi+datan(dabs(sb)/dabs(sa))
            ENDIF
         ENDIF
      ELSE
         teta=0d0
      ENDIF

      call periodo(teta)

 1000 return
      end


c     Suborutine taking theta between 0 and 2 PI GRECO
      SUBROUTINE periodo(teta)

      real*8 teta,pi,pi2
      common /npar/ pi

      pi2=2d0*pi

      IF (teta.ge.0d0) THEN
         teta=dmod(teta,pi2)
      ELSE
         IF (teta.ne.0d0) THEN
            teta=dmod(-teta,pi2)
            teta=pi2-teta
         ENDIF
      ENDIF
      
      return
      end         


C Subroutine reordering the wave vector according to the initial ordering
C (based on their physical position -> r1 ) 
      SUBROUTINE Ordina

      include "nqbit.in"
      
      integer b(nq,2**nq),r1(nq),temp,fisi
      real*8 psi(2,2**nq),nfy,niy
      common /gen/ b,psi,r1
      common /reg/ l,m
            
      m3=0

 2    CONTINUE

      Do 100 i=1,nq

         DO 10 k=1,nq
            IF(r1(k).eq.i) THEN
               fisi=k
            ENDIF
 10      CONTINUE
         
C Compute displacement in y, ny 

         nfy=(fisi*1d0)/(l*1d0)
         niy=(i*1d0)/(l*1d0)
         nfy=int(nfy+(l*1d0-5d-1)/(l*1d0))
         niy=int(niy+(l*1d0-5d-1)/(l*1d0))
         ny=(nfy-niy) 

         IF (ny.gt.0) THEN
            DO 20 j=1,ny
               call swap(fisi,fisi-l,1)                  
               fisi=fisi-l
 20         CONTINUE
         ELSE
            DO 30 j=1,-ny
               call swap(fisi,fisi+l,1) 
               fisi=fisi+l
 30         CONTINUE
         ENDIF

C Compute displacement in c, nx 
         nx=fisi-i

         IF (nx.gt.0) THEN
            DO 40 j=1,nx
               call swap(fisi,fisi-1,1)                  
               fisi=fisi-1
 40         CONTINUE
         ELSE
            DO 50 j=1,-nx
               call swap(fisi,fisi+1,1)                  
               fisi=fisi+1
 50         CONTINUE
         ENDIF

C Check order
         m1=0
         DO 90 ij=1,nq
            m1=m1+abs(r1(ij)-ij)
 90      CONTINUE
         IF (m1.eq.0) THEN
            GOTO 1000
         ENDIF

 100  CONTINUE

      m1=0
      DO 120 i=1,nq
         m1=m1+abs(r1(i)-i)
 120  CONTINUE

      IF (m3.gt.nq) THEN
         print *, 'ARIORDINA'
      ENDIF
      IF (m1.gt.0) THEN
         m3=m3+1
         goto 2
      ENDIF
 1000 CONTINUE

      return
      end


C Subroutine looking for l,m integer such that nq=l*m (two-dimensional hardware)
C M\le L.
      SUBROUTINE costruisci(nq)

      common /reg/l,m
      m=int(sqrt(nq*1.0))
      do i=1,m
      if (mod(nq,(m-i+1)).eq.0) then
         l=nq/(m-i+1)
         goto 123
      endif
      enddo
 123  continue
      m=nq/l

c      l=nq
c      m=1
c      print *, 'DIMENSION OF THE GRID OF QUBITS'
c      print *, 'x e y',l,m

      return
      end


c Funzione generating pseudorandom numbers starting from the seed idum 
c (idum<0 )
      FUNCTION ran1(idum)

      PARAMETER (IA=16807,IM=2147483647,AM=1./IM,IQ=127773,IR=2836)
      PARAMETER (NTAB=32,NDIV=1+(IM-1)/NTAB,EPS=1.2e-7,RNMX=1.-EPS)
      INTEGER iv(NTAB)
      SAVE iv,iy
      DATA iv /NTAB*0/, iy /0/
      IF (idum.le.0.or.iy.eq.0) THEN
         idum=max(-idum,0)
         DO 11 j=NTAB+8,1,-1
            k=idum/IQ
            idum=IA*(idum-k*IQ)-IR*k
            IF (idum.lt.0) idum=idum+IM
            IF (j.le.NTAB) iv(j)=idum
 11      ENDDO
         iy=iv(1)
      ENDIF
      k=idum/IQ
      idum=IA*(idum-k*IQ)-IR*k
      IF (idum.lt.0) idum=idum+IM
      j=1+iy/NDIV
      iy=iv(j)
      iv(j)=idum
      ran1=min(AM*iy,RNMX)
      return 
      end


c     Subroutine generating random dephasing in the quantum gates
      subroutine inizializzo

      include "nqbit.in"

      integer pan
      real*8 eps(18),epsi,ep(18)
      common /random/ eps,epsi,pan,kick
      common /porte/ ep,conf

      do i=1,18
         eps(i)=ran1(pan)*2*epsi-epsi
c         print *,eps(i)
      enddo
      if (kick.eq.2) then
         do i=1,18
            ep(i)=eps(i)
         enddo
      endif

      return
      end

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C    SUBROUTINES FOR DATA ANALYSIS                         C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC


C SUBROUTINE COMPUTING |<psi|psi0>|^2 
      SUBROUTINE FIDELITY(sum)
      
      include "nqbit.in"

      integer a(nq,2**nq),r1(nq)
      real*8 psi(2,2**nq),psi0(2,2**nq),ro,teta,p(2,2**nq),sum,tsum,fido
      common /gen/ a,psi,r1
      common /analisi/ psi0

      DO 10 i=1,2**nq         
         p(1,i)=psi(1,i)*psi0(1,i)
         p(2,i)=-psi(2,i)+psi0(2,i) 
 10   CONTINUE

      sum=0
      tsum=0

      DO 20 i=1,2**nq
         call csom(sum,p(1,i),tsum,p(2,i),sum,tsum)
 20   CONTINUE

      sum=sum**2

      return
      end


c Subroutine computing variance and IPR
      SUBROUTINE varianza(var,ipr)

      include "nqbit.in"

      integer a(nq,2**nq),r1(nq)
      real*8 psi(2,2**nq),ipr
      real*8 var,ai,sum,nmed
      common /gen/ a,psi,r1

      nmed=0d0

      DO 10 i=1,2**nq
         nmed=nmed+(i-2d0**(nq-1))*psi(1,i)**2
 10   CONTINUE            

      var=0d0
      ipr=0d0

      DO 20 i=1,2**nq
         var=var+(i*1d0-2d0**(nq-1))**2*psi(1,i)**2
         ipr=ipr+psi(1,i)**4
 20   CONTINUE
      var=var-nmed**2
      ipr=1d0/ipr

      return
      end
