/* *********************************************************************
   | The Q language - A C++ extension for programming quantum machines |
   | Copyright (C) 2000 2001 2002 2003 Stefano Bettelli                |
   | <bettelli@irsamc.ups-tlse.fr>                                     |
   | See the COPYING and LICENSE files for license terms.              |
   ********************************************************************* */
#ifndef __QUANTUM_COMPUTING_LIBRARY
#define __QUANTUM_COMPUTING_LIBRARY

#include <qinterface_types.h>              // setup the "quantum" types
#include <qoperator.h>                     // for the Qop class

/* *********************************************************************
   | This function returns a circuit to be run on a quantum register   |
   | with q="qubits" qubits. When acting on a basis element |n>, where |
   | n is a binary string with q bits, i.e. an integer number in the   |
   | range [0, 2^q[, it transforms |n> into exp(2 PI i f n^p) |n>,     |
   | where f="factor" is a floating point number and p="power" is an   |
   | integer number; it is thus a diagonal operator. If "qubits" is    |
   | zero or "power" is zero or "factor" is 0.0, this function returns |
   | the identity operator. If any numerical overflow is found during  |
   | the circuit construction, an exception is thrown.                 | 
   | The circuit is built in such a way that the first bit in each     |
   | register passed to the circuit will be considered, as usual, the  |
   | most significant bit (MSB).                                       | 
   |                                                                   |
   | Stefano Bettelli, IRSAMC, UPS, Toulouse,      04 May 2002         |
   ********************************************************************* */
Qop expower(::qubit_address_type qubits,
	    unsigned int power, double factor = 1.0);

#endif  // __QUANTUM_COMPUTING_LIBRARY
//;;; Local Variables: ***
//;;; mode:C++ ***
//;;; End: ***
