/* *********************************************************************
   | The Q language - A C++ extension for programming quantum machines |
   | Copyright (C) 2000 2001 2002 2003 Stefano Bettelli                |
   | <bettelli@irsamc.ups-tlse.fr>                                     |
   | See the COPYING and LICENSE files for license terms.              |
   ********************************************************************* */
#ifndef __COMMUNICATION_WITH_QUANTUM_DEVICE_DRIVER_DATA_TYPES_
#define __COMMUNICATION_WITH_QUANTUM_DEVICE_DRIVER_DATA_TYPES_

#include <climits>                       // for number of bits in a char

/* *********************************************************************
   | This type will hold the "quantum" of communication between the    |
   | language subsytem and the quantum device. C++ does not provide    |
   | integer types with a representation of a given fixed size, so     |
   | this will turn out to be a difference when moving to architectu-  |
   | res where an unsigned long is not a 32-bit data type. Dangerous?  |
   | (26 Sep 2001) S.Bettelli. Provide also a signed version.          |
   | (30 Apr 2002) S.Bettelli. Remove the signed version.              |
   |                                                                   |
   | Stefano Bettelli, INFN and Trento University, 17 Jan 2001         |
   | Stefano Bettelli, IRSAMC, UPS, Toulouse,      30 Apr 2002         |
   ********************************************************************* */
typedef unsigned long quantum_message_type;

/* *********************************************************************
   | This constant is the number of bits in a quantum_message_type     |
   | number and is to be used when bit masks are to be compressed in   |
   | blocks made out of such numbers. CHAR_BIT is the number of bits   |
   | in a character for the current architecture.                      |
   |                                                                   |
   | Stefano Bettelli, INFN and Trento University, 01 Sep 2001         |
   ********************************************************************* */
#define QUANTUM_MESSAGE_TYPE_SIZE ( sizeof(quantum_message_type) * CHAR_BIT )

/* *********************************************************************
   | A qubit logical address will be an integer in the range of this   |
   | unsigned type; use the quantum_message_type so that it will be    |
   | simpler to send an address to the quantum device.                 |
   |                                                                   |
   | Stefano Bettelli, INFN and Trento University, 17 Jan 2001         |
   ********************************************************************* */
typedef quantum_message_type qubit_address_type;

/* *********************************************************************
   | The size of a segment of logical qubit addresses will be an       |
   | integer in the range of this unsigned type. It must contain every |
   | possible difference between two qubit_address_type values (which  |
   | are unsigned), hence it is the same type as qubit_address_type.   |
   |                                                                   |
   | Stefano Bettelli, INFN and Trento University, 17 Jan 2001         |
   ********************************************************************* */
typedef qubit_address_type qubit_segment_size_type;

/* *********************************************************************
   | The following two types specify the interface which will be used  |
   | for phase-like operators. A phase will be writte in the form      |
   | exp(2 PI i x / 2^k) where the "power" k is an unsigned integer    |
   | number and the "fraction" x is a floating point number.           |
   |                                                                   |
   | Stefano Bettelli, IRSAMC, UPS, Toulouse,      30 Apr 2002         |
   ********************************************************************* */
typedef unsigned int quantum_phase_power_type;
typedef double       quantum_phase_floating_type;

#endif  // __COMMUNICATION_WITH_QUANTUM_DEVICE_DRIVER_DATA_TYPES_
//;;; Local Variables: ***
//;;; mode:C++ ***
//;;; End: ***
