/* *********************************************************************
   | The Q language - A C++ extension for programming quantum machines |
   | Copyright (C) 2000 2001 2002 2003 Stefano Bettelli                |
   | <bettelli@irsamc.ups-tlse.fr>                                     |
   | See the COPYING and LICENSE files for license terms.              |
   ********************************************************************* */
#include <qop_slice_basegate.h>                 // the class declaration
#include <qop_summary.h>                        // the base gate database

/* *********************************************************************
   | This is the full-featured constructor for a base gate object. It  |
   | takes care to initialise all the data members of the class and to |
   | register the gate with the gate database (sending a pointer to    |
   | the current object). The return value of the registration routine |
   | is saved in the "index" member.                                   | 
   |                                                                   |
   | Stefano Bettelli, IRSAMC, UPS, Toulouse,      10 Nov 2002         |
   ********************************************************************* */
Qop_slice_basegate::Qop_slice_basegate
(opcode_type the_opcode, const char *the_name, bool has_parameter) :
  /* initialise all the class members but the index. */
  opcode(the_opcode), name(the_name), parametrised(has_parameter) {
  /* register a pointer to the gate and save its index. */
  index = Qop_summary::register_basegate(this);
}

//;;; Local Variables: ***
//;;; mode:C++ ***
//;;; End: ***
