/* *********************************************************************
   | The Q language - A C++ extension for programming quantum machines |
   | Copyright (C) 2000 2001 2002 2003 Stefano Bettelli                |
   | <bettelli@irsamc.ups-tlse.fr>                                     |
   | See the COPYING and LICENSE files for license terms.              |
   ********************************************************************* */
#include <qop_basegates.h>             // declarations for these objects

/* *********************************************************************
   | These global constant objects will be referenced by all the time  |
   | slices for getting information about their base gates. Different  |
   | gate sets should register different base gates.                   |
   |                                                                   |
   | Stefano Bettelli, IRSAMC, UPS, Toulouse,      10 Nov 2002         |
   ********************************************************************* */

extern const Qop_slice_basegate
BASEGATE_HADAMARD  (OPCODE_HADAMARD,   "Hadamard",  false);

extern const Qop_slice_basegate
BASEGATE_PHASE     (OPCODE_PHASE,      "Phase",     true);

extern const Qop_slice_basegate
BASEGATE_COND_PHASE(OPCODE_COND_PHASE, "CondPhase", true);

extern const Qop_slice_basegate
BASEGATE_SWAP      (OPCODE_SWAP,       "Swap",      false);

//;;; Local Variables: ***
//;;; mode:C++ ***
//;;; End: ***
