#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include "qAlgebra.h"
#include "evolop.h"
#include "hasard.h"
#include "nrutil.h"

int main()
{  
  int Nq=6;
  int ip=1<<5;    //so that p=1/2^5=0.03125	       
  double W=0.5;	
  
  int boumax=20;  // mean taken on boumax random networks
  double t=200;          // max. time
  double dt=0.03;        // time step
  
  int repet=int(t/dt);  // Nr of iterations of exp(i H dt)   
  int Nst=1<<Nq;
  double p=1.0/ip;
  double V=1;   //Coupling strength between neighbours
  
  int facto(int);
  void EiH0(QBitsWaveFunction&, QBitsWaveFunction);
  void EiH1rap(QBitsWaveFunction&, const Binomes&);
  void EiH2sim(QBitsWaveFunction&, const Wave01&,double); 
  void fprintPsi(FILE*, const QBitsWaveFunction&);
  void EiH21012rap(QBitsWaveFunction&, QBitsWaveFunction, const Wave01&, const Binomes&, double, int);    
  void EiH21012(QBitsWaveFunction&, QBitsWaveFunction, const Wave01&,  double, int);   
  void DiagSimuleGaussien(QBitsWaveFunction&, double, double);
  void EiH1exarap(QBitsWaveFunction&, const Binomes&);
  void SmallSimulePermutation(Wave01&, int);
  void SmallSimulePermutationSimplifie(Wave01&, int);
  void DiagExacteGaussienne(QBitsWaveFunction&, double, double);
  
  QBitsWaveFunction C(Nq);
  QBitsWaveFunction DiagC(Nq);   
  Wave01 ImC(Nq); 
  
  
  int expamax=5; 
  Binomes Cnk(expamax);
  for(int u=0;u<expamax;u++)
    for(int v=0;v<u+1;v++)
      Cnk.wf[u*expamax+v]=pow(V*dt*I, u)*(1./facto(v)/facto(u-v));
  
  int pN=int(p*Nst+0.5);
  float *evolution; 
  evolution=vector(1,repet*boumax);
  for(int i=1;i<=repet*boumax;i++)evolution[i]=0;
  
  for(int bou=0;bou<boumax;bou++)
    { if((bou%1)==0)printf("On en est a bou=%i\n", bou);
      QBitsWaveFunction C(Nq), DiagC(Nq);   
      Wave01 ImC(Nq); 
      DiagSimuleGaussien(DiagC, dt*.5, W);
      SmallSimulePermutationSimplifie(ImC, pN);
      C.SetZero();		   
      for(int tps=1;tps<=repet;tps++)
	{ EiH21012rap(C, DiagC, ImC, Cnk, dt*V, pN);
	  //EiH21012(C, DiagC, ImC, dt*V, pN);
	  evolution[repet*bou+tps]+=C.participation();
	}
    }
  
  
  char ev[256];
  sprintf(ev, "smallworld%ip%iw%i.dat", Nq, ip, int(10.*W+0.0001) );
  FILE* fev=fopen(ev, "w");
    
  for(int tps=1;tps<=repet;tps++)
    { double evo=0;
      for(int bou=0;bou<boumax;bou++)
	evo+=evolution[repet*bou+tps];
      fprintf(fev,"%f\t%f\n", tps*dt, evo/(1.0*boumax));
    }

   fclose(fev);
   
   return 0;
}




//***************************************************************
//***************************************************************
//***************************************************************
//***************************************************************
//***************************************************************
//***************************************************************
//***************************************************************
//***************************************************************



void fprintPsi(FILE* fichier, const QBitsWaveFunction& Psi)
{
  for(int j=0;j<Psi.N;j++)
    fprintf(fichier, "%f\n", arg(Psi.wf[j]));
  return;
}

//================================================================
//---                 DEFINITION DES FUNCTIONS              ----//     
//----------------------------------------------------------------

//-------------PARTIE DIAGONALE------------- 
void EiH0(QBitsWaveFunction& Psi,QBitsWaveFunction D)
        {
	  for(int i=0;i<Psi.N;i++)
	    Psi.wf[i]=Psi.wf[i]*D.wf[i];
	}


//-----------Simulation of links between neignbours -------
   // We have exp(iH)=QFT . exp(2iV cos(2kpi/N)) . QFT^-1   


void EiH1rap(QBitsWaveFunction& Psi, const Binomes& Cnk)
{
  int Nst=Psi.N;
  int max=Cnk.M;
  QBitsWaveFunction Aux(Psi.n);
  complex<double> au=0;
  for(int i=0;i<Nst;i++)
    { au=0;
      int gardu=0, gardi=Nst+Nst+i;
      for(int u=0;u<max;u++)
	{ for(int v=0;v<u+1;v++)
	    au=au+(Cnk.wf[gardu+v])*Psi.wf[(gardi+u-v-v) % Nst];
	  gardu+=max;
	  
	}
      Aux.wf[i]=au;
    }
  Psi=Aux;
  return;
}  





  //-------------Smallworld links-------------
    
void EiH2exa(QBitsWaveFunction& Psi,  const Wave01& Image, double dtV)
{   
  Wave01 dejaechange(Psi.n);   // we put 1 if already permuted
  dejaechange.Init();
  complex<double> tmp, isn=sin(dtV)*I;
  double cs=cos(dtV);  
  for(int i=0;i<Psi.N;i++)
    if(Image.wf[i]>-1)
      if(dejaechange.wf[i]==-1)
	{ tmp=Psi.wf[i]; 
	  Psi.wf[i]=tmp*cs+Psi.wf[Image.wf[i]]*isn; 
	  Psi.wf[Image.wf[i]]=tmp*isn+Psi.wf[Image.wf[i]]*cs;
	  dejaechange.wf[Image.wf[i]]=1;
	};
  return;
}

void EiH1sim(QBitsWaveFunction& Psi, double dtV)
{
  Psi << Fft(-1);        
  // Slicing of the operator:  L steps
  int L=10, Nq=Psi.n;
  double g=-2*dtV/L; //small parameter
  for( int i=0;i<L;i++)
    { Psi << WH(Nq-1);
      double ang=-M_PI*0.5;
      for(int j=Nq-2;j>-1;j--)
	{ Psi << CRot(Nq-1,j, ang);
	  ang*=.5;
	}
      Psi << WH(Nq-1) << Rot(-g*.5, Nq-1) << WH(Nq-1);
      ang=M_PI;
      for(int j=Nq-2;j>-1;j--)
	{ Psi << CRot(Nq-1,j, ang);
	  ang*=.5;
	}
      Psi << WH(Nq-1) << Rot(-g, Nq-1) << WH(Nq-1);
      ang=-M_PI;
      for(int j=Nq-2;j>-1;j--)
	{ Psi << CRot(Nq-1,j, ang);
	  ang*=.5;
	}
      Psi << WH(Nq-1) << Rot(-g*.5, Nq-1) << WH(Nq-1);
      ang=M_PI*.5;
      for(int j=Nq-2;j>-1;j--)
	{ Psi << CRot(Nq-1,j, ang);
	  ang*=.5;
	}
      Psi << WH(Nq-1);
    }
  Psi << Fft(1);
  return;    
}

void EiH2sim(QBitsWaveFunction& Psi, const Wave01& Image, double dtV)
{   
  Wave01 dejaechange(Psi.n);   //  1 if already permuted
  dejaechange.Init();
  complex<double> tmp, isn=sin(dtV)*I;
  double cs=cos(dtV);  
  for(int i=0;i<Psi.N;i++)
    if(Image.wf[i]>-1)
      if(dejaechange.wf[i]==-1)
	{ tmp=Psi.wf[i]; 
	  Psi.wf[i]=tmp*cs+Psi.wf[Image.wf[i]]*isn; 
	  Psi.wf[Image.wf[i]]=tmp*isn+Psi.wf[Image.wf[i]]*cs;
	  dejaechange.wf[Image.wf[i]]=1;
	};
  return;
}

void EiH21012rap(QBitsWaveFunction& Psi, QBitsWaveFunction Diag, const Wave01& Im, const Binomes& CC, double dtV, int pp)    
{
  double dtV2=dtV*0.5;
  if(pp>0)EiH2sim(Psi, Im, dtV2);
  EiH0(Psi, Diag);
  EiH1rap(Psi, CC);
  EiH0(Psi, Diag);
  if(pp>0)EiH2sim(Psi, Im, dtV2);
 return;
}

void EiH21012(QBitsWaveFunction& Psi, QBitsWaveFunction Diag, const Wave01& Im, double dtV, int pp)    
{
  double dtV2=dtV*0.5;
  if(pp>0)EiH2sim(Psi, Im, dtV2);
  EiH0(Psi, Diag);
  EiH1sim(Psi, dtV);
  EiH0(Psi, Diag);
  if(pp>0)EiH2sim(Psi, Im, dtV2);
 return;
}



void DiagSimuleGaussien(QBitsWaveFunction& Diag, double ddt, double w)
{   
  int Nq=Diag.n;
  Diag.Allone();
  //Diag contains  exp(I eps_i t) pseudo-random
  int M=30*Nq;
  int *ik=new int[M], *jk=new int[M];
  for(int i=0;i<M;i++)
    {*(ik+i)=int(hasard()*Nq);
      *(jk+i)=int(hasard()*Nq);
    }
  double sigma=w*ddt*sqrt(3.0/(Nq+M));
  for(int i=0;i<Nq;i++)
    Diag << Rot(2*sigma*(hasard()-.5),i);  
  for(int i=0;i<M;i++)
    { Diag << Cnot(*(ik+i),*(jk+i));
      Diag << Rot(2*sigma*(hasard()-.5),*(jk+i));
    }
  for(int i=0;i<M;i++)
    Diag << Cnot(*(ik+M-1-i),*(jk+M-1-i));
  return;
}


//----------I.3 Smallworld links simulated ---------------
void SmallSimulePermutation(Wave01& Im, int pN)
{
  int Nq=Im.n, Nst=Im.N;
  Wave01 Aux(Nq), Invaux(Nq);
  Aux.Alli(); //Aux containts the permutation by Cnot     
  Invaux.Alli();
  int M=3*Nq;
  int *ik=new int[M], *jk=new int[M];
  int *ak=new int[M], *invak=new int[M], *bk=new int[M];
  for(int i=0;i<M;i++)
    { *(ik+i)=int(hasard()*Nq);
      do{*(jk+i)=int(hasard()*Nq);}while((*(jk+i))==(*(ik+i)));
      int a=0;
      while(((a%2)==0)||(a<0.25*Nst)||(a>0.75*Nst))a=int(hasard()*Nst);
      int inva=0;
      while(((inva*a)%Nst)!=1)inva++;
      int b=int(hasard()*Nst);
      *(ak+i)=a;
      *(invak+i)=inva;  
      *(bk+i)=b;  
    }
  for(int i=0;i<M;i++)
    { Aux.Cnot(*(ik+i),*(jk+i));
      Im=Aux;
      for(int j=0;j<Nst;j++)
	Aux.wf[j]=Im.wf[((*(invak+i))*(Nst+j-(*(bk+i)))) % Nst];
    }
  for(int i=0;i<M;i++)
    { Im=Invaux;
      for(int j=0;j<Nst;j++)
	Invaux.wf[j]=Im.wf[((*(ak+M-1-i))*j+(*(bk+M-1-i))) % Nst];
      Invaux.Cnot(*(ik+M-1-i),*(jk+M-1-i));
    }
  int *fixes=new int[Nq*Nq];
  int *mouvant=new int[Nq];  //contains the qbit flipped in the Control_m
  int debogmax=100, debog=debogmax;  
  while(debog==debogmax)
    {
      debog=0;
      for(int i=0;i<Nq*Nq;i++)
	*(fixes+i)=-1;    // fixes contains the fixed qbits
      for(int i=0;i<Nq;i++)
	*(mouvant+i)=-1;  // fixes contains the moving qbit 
      for(int kk=0;kk<Nq;kk++)
	if((pN&(1<<kk))&&(debog<debogmax))
	  { int Mq=Nq-1-kk; // Mq in the nr of qbits fixed in Control(m) 
	    //at step kk
	    bool pasbon=true;   
	    // to verify that the place is drawn only once
	    int nouveau=0;
	    debog=0;
	    while(pasbon&&(debog<debogmax))
	      { debog++;
		for(int nb=0;nb<Nq;nb++)
		  *(fixes+kk*Nq+nb)=-1;
		for(int nombretires=0; nombretires<Mq; nombretires++)
		  { do {nouveau=int(hasard()*Nq);}
		    while((*(fixes+kk*Nq+nouveau))>-1);
		    (*(fixes+kk*Nq+nouveau))=int(hasard()*2); 
		  }
		int rr=0;
		bool remplace=true;
		while((remplace)&&(rr<kk)) 
		  //remplace=true=one of the fixed qbits is different
		  { bool rrvide=true;
		    for(int j=0; j<Nq;j++)
		      if((*(fixes+rr*Nq+j))>-1)
			{ rrvide=false;
			  if((*(fixes+kk*Nq+j))>-1)
			    remplace=remplace&&abs(1-(*(fixes+kk*Nq+j))-(*(fixes+rr*Nq+j)));
			}
		    rr++;   //compares choice at kk with the rr choices before
		    remplace=(rrvide)?rrvide:(!remplace);
		  }
		if((rr==kk)&&remplace)pasbon=false;
	      }
	    bool pastrouvemouvant=true;
	    int mouv=0;
	    while(pastrouvemouvant)
	      { mouv=int(hasard()*Nq);
		if(*(fixes+kk*Nq+mouv)<0)pastrouvemouvant=false;
	      }
	    *(mouvant+kk)=mouv;
	  }
    }

  Im.Init();     
  for(int i=0;i<Nst;i++)
    { // on teste successivement toutes les formes possibles rr
      int kk=Nq-1;
      bool cestpasok=true;
      while((cestpasok)&&(kk>-1))
	{ if(pN&(1<<kk))
	    { int j=0, k=0;   //k parcourt les Nq, j cmpte le nb de fixes vus
	      bool cp=true;  //cp teste si ts les qbits sont a la bonne place
	      int Mq=Nq-1-kk;	     
	      int imi=Aux.wf[i];   // On fait la permutation
	      while(cp&&(j<Mq))
		{ if((*(fixes+kk*Nq+k))>-1)
		    { if((*(fixes+kk*Nq+k))==1)
			cp=((1<<k)&imi);
		      else
			cp=(!((1<<k)&imi));
		      j++;
		    }
		  k++;
		} //c'est le control des m qbits
	      if(cp)
		{ cestpasok=false;  //i.e. c'est un etat a modifier
		  int ii=imi;
		  int dautre=1<<(*(mouvant+kk));	    
		  if(ii&dautre)
		    ii-=dautre;   
		  else
		    ii+=dautre;
		  Im.wf[i]=Invaux.wf[ii];
		}
	    }
	  kk--;
	}
    }
  return;
}


//----------I.3 Liens smallworld" simules ---------------
//dans le cas ou p=1/2^r:
void SmallSimulePermutationSimplifie(Wave01& Im, int pN)
{
  int Nq=Im.n, Nst=Im.N, kk=0;
  for(int i=0;i<Nq;i++)
    if(pN&(1<<i))kk=i;
  Wave01 Aux(Nq), Invaux(Nq);
  Aux.Alli(); //Aux contient la permutation suppl par des Cnot     
  Invaux.Alli();
  int M=3*Nq;
  int *ik=new int[M], *jk=new int[M];
  int *ak=new int[M], *invak=new int[M], *bk=new int[M];
  for(int i=0;i<M;i++)
    { *(ik+i)=int(hasard()*Nq);
      do{*(jk+i)=int(hasard()*Nq);}while((*(jk+i))==(*(ik+i)));
      int a=0;
      while(((a%2)==0)||(a<0.25*Nst)||(a>0.75*Nst))a=int(hasard()*Nst);
      int inva=0;
      while(((inva*a)%Nst)!=1)inva++;
      int b=int(hasard()*Nst);
      *(ak+i)=a;
      *(invak+i)=inva;  
      *(bk+i)=b;  
    }
  for(int i=0;i<M;i++)
    { Aux.Cnot(*(ik+i),*(jk+i));
      Im=Aux;
      for(int j=0;j<Nst;j++)
	Aux.wf[j]=Im.wf[((*(invak+i))*(Nst+j-(*(bk+i)))) % Nst];
    }
  for(int i=0;i<M;i++)
    { Im=Invaux;
      for(int j=0;j<Nst;j++)
	Invaux.wf[j]=Im.wf[((*(ak+M-1-i))*j+(*(bk+M-1-i))) % Nst];
      Invaux.Cnot(*(ik+M-1-i),*(jk+M-1-i));
    }
  int *fixes=new int[Nq];
  int mouvant=int(hasard()*Nq);//contient le qbit qu'on flipe dans le Control_m
  for(int i=0;i<Nq;i++)
    *(fixes+i)=-1;    // fixes contient les qbits qu'on fixe

  int Mq=Nq-1-kk; // Mq est le nb de qbits qu'on veut fixer dans le Control(m)
  int nouveau=0;
  for(int nombretires=0; nombretires<Mq; nombretires++)
    { do {nouveau=int(hasard()*Nq);}
      while(((*(fixes+nouveau))>-1)||(nouveau==mouvant));
      (*(fixes+nouveau))=int(hasard()*2); 
    }
  
  Im.Init();     
  for(int i=0;i<Nst;i++)
    { int j=0, k=0;   //k parcourt les Nq, j cmpte le nb de fixes vus
      bool cp=true;  //cp teste si ts les qbits sont a la bonne place
      int Mq=Nq-1-kk;	     
      int imi=Aux.wf[i];   // On fait la permutation
      while(cp&&(j<Mq))
	{ if((*(fixes+k))>-1)
	    { if((*(fixes+k))==1)
		cp=((1<<k)&imi);
	      else
		cp=(!((1<<k)&imi));
	      j++;
	    }
	  k++;
	} //c'est le control des m qbits
      if(cp)
	{ int ii=imi;
	  int dautre=1<<mouvant;	    
	  if(ii&dautre)
	    ii-=dautre;   
	  else
	    ii+=dautre;
	  Im.wf[i]=Invaux.wf[ii];
	}
    }
  return;
}



int facto(int n)
{
  int u=1;
  for(int i=2;i<n+1;i++)
    u*=i;
  return u;
}

