#ifndef _WAVE01_H_
#define _WAVE01_H_


#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <complex>
#include "qubits.h"
#include "qAlgebra.h"
using std::complex;

//This class is a qbitWaveFunction but taking only values 0 and 1

class Wave01
{ 
  public:
  int n;               // number of qubits
  long N;
  int *wf;  // pointer to Wave Function buffer
  char WFname[16];     // name of Wave Function (optional)
  
//-------- Constructor of wavefunction object, nq - number of qubits  
  
Wave01(int nq,char* name=0) // 
	{ n=nq;
	  N=1<<n;
	  if(name) { strncpy(WFname,name,15); WFname[15]=0;}
	  else strcpy(WFname,"unnamed");
	  wf=(int*)calloc(N,sizeof(int));
	  if(wf==0) 
	    { printf("Fail to init wave function %s\n",WFname);
	      abort();
	    };	
	};
	
  Wave01(const Wave01& QBwf, char* name="unnamed") // cloning of wave function
	{ n=QBwf.n; N=QBwf.N;
	  strncpy(WFname,name,15); WFname[15]=0; //truncate name by 15 chars
	  wf=(int*)calloc(N,sizeof(int));
	  if(wf==0) 
	    { printf("Fail to init wave function %s\n",WFname);
	      abort();
	    };	
	  memcpy(wf,QBwf.wf,N*sizeof(int));      
	};
	
    ~Wave01() { free(wf);};

// equating two wave functions
Wave01& operator = (const Wave01& QBwf) 
	{ if(N!=QBwf.N)
          { n=QBwf.n;
	    N=QBwf.N;
	    if(wf) free(wf);
	    wf=(int*)calloc(N,sizeof(int));
	    if(wf==0) 
	      { printf("Fail to init wave function %s\n",WFname);
	        abort();
	      };
	  };	
	  strcpy(WFname,"equal_tmp");
	  memcpy(wf,QBwf.wf,N*sizeof(int));
	  return *this;      
	};

Wave01& X(int j) 
	{ if(j<0 || j>=n) { printf("X: j=%d out of range\n",j); abort();}; 
	  int i1=1<<j;
	  int tmp;
          for(int i=0; i<N; i++) 
	    if(i1&i) { tmp=wf[i]; wf[i]=wf[i-i1]; wf[i-i1]=tmp;}; 
	  return *this;    
	};


Wave01& Cnot(int j1,int j2) 
	{ if(j1<0 || j1>=n) { printf("Cnot: j1=%d out of range\n",j1); abort();}; 
	  if(j2<0 || j2>=n) { printf("Cnot: j2=%d out of range\n",j2); abort();}; 
	  int i1=1<<j1,i2=1<<j2;
	  int tmp;
          for(int i=0; i<N; i++) 
	    if(i1&i) 
	      if(i2&i){ tmp=wf[i]; wf[i]=wf[i-i2]; wf[i-i2]=tmp;}; 
	  return *this;    
	};

	
Wave01& SetZero() 
	{ 
          for(long i=0; i<N; i++) wf[i]=0;
	  wf[0]=1;
	  return *this;    
	};

Wave01& Init() 
	{ 
          for(long i=0; i<N; i++) wf[i]=-1;
	  return *this;    
	};

Wave01& Alli() 
	{ 
          for(long i=0; i<N; i++) wf[i]=i;
	  return *this;    
	};



void print()
        { 
	  printf("%s =\n",WFname);
	  for(int i=0; i<N;i++)
	    printf("%i\t%i\n",i,wf[i]);
	  };   	
}; //=============== end of class "Wave01" 


//=======================Class tableau de Cnk ++++++================
class Binomes
{ public:
  int M;
  int MM;
  complex<double> *wf;    
  
  Binomes(int nmax) // 
    { M=nmax;
      MM=nmax*nmax;
      wf=(complex<double>*)calloc(MM,sizeof(complex<double>));
    };
  
  ~Binomes() { free(wf);};
  
  void print()
  { for(int i=0; i<MM;i++)
      printf("%f\t%f\n",real(wf[i]), imag(wf[i]));
  };   
};



//=======================Class tableau de Cnk ++++++================
class Errs
{ public:
  int M;
  double *wf;    
  
  Errs(int nmax) // 
    { M=nmax;
      wf=(double*)calloc(M,sizeof(double));
    };
  
  ~Errs() { free(wf);};
  
  void print()
  { for(int i=0; i<M;i++)
      printf("%f\n", wf[i]);
  };   
};


class H1
{ 
  public:
  int n;               // number of qubits
  long N;
  complex<double> *wf;  // pointer to Wave Function buffer
  char WFname[16];     // name of Wave Function (optional)
  
//-------- Constructor of wavefunction object, nq - number of qubits  
  
H1(int nq,char* name=0) // 
	{ n=nq;
	  N=1<<(2*n);
	  if(name) { strncpy(WFname,name,15); WFname[15]=0;}
	  else strcpy(WFname,"unnamed");
	  wf=(complex<double>*)calloc(N,sizeof(complex<double>));
	  if(wf==0) 
	    { printf("Fail to init wave function %s\n",WFname);
	      abort();
	    };	
	};
	
  H1(const H1& QBwf, char* name="unnamed") // cloning of wave function
	{ n=QBwf.n; N=QBwf.N;
	  strncpy(WFname,name,15); WFname[15]=0; //truncate name by 15 chars
	  wf=(complex<double>*)calloc(N,sizeof(complex<double>));
	  if(wf==0) 
	    { printf("Fail to init wave function %s\n",WFname);
	      abort();
	    };	
	  memcpy(wf,QBwf.wf,N*sizeof(complex<double>));      
	};
	
    ~H1() { free(wf);};

// equating two wave functions
H1& operator = (const H1& QBwf) 
	{ if(N!=QBwf.N)
          { n=QBwf.n;
	    N=QBwf.N;
	    if(wf) free(wf);
	    wf=(complex<double>*)calloc(N,sizeof(complex<double>));
	    if(wf==0) 
	      { printf("Fail to init wave function %s\n",WFname);
	        abort();
	      };
	  };	
	  strcpy(WFname,"equal_tmp");
	  memcpy(wf,QBwf.wf,N*sizeof(complex<double>));
	  return *this;      
	};

H1& Zero() 
	{ 
          for(long i=0; i<N; i++) wf[i]=0;
	  return *this;    
	};

}; //=============== end of class "H1" 

#endif
