// Phase estimation algo. w/unitary noise...

#define RANGE_CHECK 

#include "complex.h"
#include "random.h"
#include "quantum.h"
#include <time.h>
#include <math.h>
#include <iostream>
using namespace std;

#define GLOBAL_FILE "all_stat_fid.dat"

#define SAVE_SECONDS 60  // number of seconds between saving of quantum states
/***********************************/ 
inline double Max(double x,double y) { if(x>y) { return x;} else return y;};
inline double Min(double x,double y) { if(x<y) { return x;} else return y;};
//---------------------------------------------------
//
double DOSPI=2*M_PI;
   int L=2;
   int i1,i2;
   double Nk1,Nk2;
   int parec_num=3;
   double err=0.005;
   double suma=0.;
   int nbr,choice,k,parec_flag;
   double alpha,alpha2,delt,fa1,fa2;
   double rnd,rnd1,rnd2,rnd3;
   double epsilon,epsilon1,epsilon2,epsilon3,epsilon4;
//
   complex e_ialpha,e_iomega,e_ialpha2,e_iomega2;
//   
   qubit_state a_tot(L);
   qubit_state a_alt(L);
//
   double P00=0.;double P01=0.;double P10=0.;double P11=0.;
   double Q00=0.;double Q01=0.;double Q10=0.; double Q11=0.;   
//define the value for the first parec run
void define_first_i1i2(){
if(parec_flag){
   i1=((int)(4.*(random_rectangular_old(2.)+1.)/2.));
   i2=((int)(4.*(random_rectangular_old(2.)+1.)/2.));}
}
//****************************************************
void NEWLINE(){
printf("\n");
}
//****************************************************
void initial_message(){
if(epsilon<0){
printf("****************************************************\n");
printf("** 5 input values required:                       **\n");
printf("****************************************************\n");
printf("** syntax: ./pea.out eps alpha k choise 	  **\n");
printf("****************************************************\n");
printf("** eps:    noise strength                         **\n");
printf("** alpha:  phase  (0<alpha<1)                     **\n");
printf("** k:      number of digits                       **\n");
printf("** choise: type of noise                  	  **\n");
printf("** 	   1...4 -> random                     	  **\n");
printf("** 	   5,6   -> static			  **\n");
printf("** 	   0=parec NO				  **\n");
printf("****************************************************\n");
	fehler("bye...");
}else{
	printf("need 5 input values\n");
	fehler("run \n $./pea.out -1     for instructions\n sorry... bye!");
   }
}
void init_eps(){
   epsilon1=epsilon2=epsilon3=epsilon4=0.;
if(choice==1)epsilon1=epsilon;
if(choice==2)epsilon2=epsilon;
if(choice==3)epsilon3=epsilon;
if(choice==4)epsilon1=epsilon2=epsilon3=epsilon;
if(choice==5)epsilon4=epsilon;
if(choice==6)epsilon1=epsilon2=epsilon3=epsilon4=epsilon;
}
//**************************************/
void gen_rnd(){
rnd=rnd1=rnd2=rnd3=0.;
if(epsilon>0.){
   rnd=random_rectangular(epsilon/4.); //factor 4. is just to better adjust to wendin
   rnd1=(choice==1||choice==4||choice==6? rnd:0);
   rnd2=(choice==2||choice==4||choice==6? rnd:0);
   rnd3=(choice==3||choice==4||choice==6? rnd:0);
   }
   
}
//**************
void Hadamard(){
   a_tot.A_gate_noise(L-1,epsilon1) ;			// Hadamard
   a_alt.A_gate_noise(L-1,epsilon1) ;			// Hadamard
}
//****
void control_phase(){
   a_tot.BB2_gate(L-2,L-1,e_ialpha);   // controlled phase gate  
   a_alt.BB2_gate(L-2,L-1,e_ialpha2);
}
//*******************
void draw_stat(){
//
  load_seed();
  if(epsilon4>0.){
	epsilon4=epsilon4/((double)parec_num);
//epsilon4/3.;  //factor 3. has to do with the parec process
  a_tot.draw_couplings(M_PI*epsilon4/4.,M_PI*epsilon4/4.,1.,0);
  a_alt.draw_couplings(M_PI*epsilon4/4.,M_PI*epsilon4/4.,1.,0);
  }
  save_seed();
  //
}
//
void error_estatico(){
   if(choice>4){a_tot.stat_error(1.,1);a_alt.stat_error(1.,1);}
}
//********************
void PAULI(qubit_state &a,int m,int n){
if(n==1){
a.Pauli_x(m);
//printf("pauli x\n");
}
if(n==2){
a.Pauli_y(m);
//printf("pauli y\n");
}
if(n==3){
a.Pauli_z(m);
//printf("pauli z\n");
}
if(n==0){
  //printf("identity\n");
}

}
//********************
void error_estatico_parec(){
//
if(epsilon>0.){
  
  if(parec_flag==1){
   for(int i=0;i<parec_num;i++){
    define_first_i1i2();
    PAULI(a_tot,0,i1);PAULI(a_tot,1,i2);
    PAULI(a_alt,0,i1);PAULI(a_alt,1,i2);
//    printf("parec coefs\t %d\t %d !!!!\n",i1,i2);
    error_estatico();
    PAULI(a_tot,0,i1);PAULI(a_tot,1,i2);
    PAULI(a_alt,0,i1);PAULI(a_alt,1,i2);
//        printf("parec coefs\t %d\t %d !!!!\n",i1,i2);
     }
   }else{
    error_estatico();error_estatico();error_estatico();
   }
 }
}
//********************
void e_e_parec_ext(){
//
if(epsilon>0.){
  if(parec_flag){
    PAULI(a_tot,0,i1);PAULI(a_tot,1,i2);
    PAULI(a_alt,0,i1);PAULI(a_alt,1,i2);
    printf("parec coefs\t %d\t %d\n",i1,i2);
    error_estatico();
    PAULI(a_tot,0,i1);PAULI(a_tot,1,i2);
    PAULI(a_alt,0,i1);PAULI(a_alt,1,i2);
        printf("parec coefs\t %d\t %d\n",i1,i2);
   }else{
    error_estatico();error_estatico();error_estatico();
   }
 }
}
//*****************
void correct_z(){
   a_tot.sigma_z_rot(L-1,e_iomega);
   a_alt.sigma_z_rot(L-1,e_iomega);
}
//
void compute_probs(){
   P00=real_teil(a_tot(0)*conj(a_tot(0)));
   P10=real_teil(a_tot(2)*conj(a_tot(2)));
   P01=real_teil(a_tot(1)*conj(a_tot(1)));
   P11=real_teil(a_tot(3)*conj(a_tot(3)));
   Q00=real_teil(a_alt(0)*conj(a_alt(0)));
   Q10=real_teil(a_alt(2)*conj(a_alt(2)));
   Q01=real_teil(a_alt(1)*conj(a_alt(1)));
   Q11=real_teil(a_alt(3)*conj(a_alt(3)));
}
//**************************************/
// computes mth coef. of the binary expantion of
// a number like phi= phi_0*2^0+phi_1*2^1+...+phi_m*2^m+...
// phi_0 i the integer part and we do not pay attention to phi_0 
int phi_m(double fase,int m){
int phim;
fase=fase*EXP2(m);
phim=(((int)fase)&1);
return phim;
}
//********************************************
void gen_alpha(){
//generate alpha with binary expansion truncated at k+1
   alpha2=0.;
   for(int i=0;i<k+1;i++){
        alpha2=alpha2+((double)phi_m(alpha,i))/((double)EXP2(i));
    } 
   if(alpha<0.0) alpha2=-alpha2;
//   printf("alpha    \t    alpha2\n");
//   printf("%18.17lf    \t    %18.17lf\n",alpha,alpha2);
   delt=fabs(alpha-alpha2);
//   printf("delt=%lf\n",delt);
}

//*************************************************************************
//Full Hadamard H^{\otimes nqubits} 
// |00000>|1010111>
// do hadamard only on the first L-nbr qubits       
// L...nbr  if fl=0
// or
// on the last nbr qubits	
//-----------------------------------
void full_H(qubit_state &a,int nbr,int fl){
  int L,i;
L=a.L();
if(fl==0){
for(i=L-1;i>=nbr;i--)
       a.A_gate(i);
}else{
for(i=L-1-nbr;i>=0;i--)
       a.A_gate(i);
}
}

void pt_bin(int n,int dig){
// returns n in binary rep, with *dig* digits,
// i.e, if n = 2 and dig = 4, then it prints
// $ 0010 
printf("|");
for(int i=dig-1;i>=0;i--){
if(n&(1<<i))
  printf("1");
else
  printf("0");
}
printf(">");
}

void pt_bin(int n,int dig1, int dig2){
printf("|");
for(int i=dig1-1;i>=0;i--){
if(n&(1<<i))
  cout<<'1';
else
  cout<<'0';
if(i==dig2)
   printf(">|");
}
printf(">");
}
//**********************************************
void pt_q(qubit_state &a){
int L,dim;
double r_a,i_a;
L=a.L();
dim=EXP2(L);
for(int i=0;i<dim;i++){
r_a=real_teil(a(i));
i_a=imag_teil(a(i));
if(r_a!=0.||i_a!=0.){
   if(r_a!=0. && i_a!=0.){
	print(a(i));
	pt_bin(i,L);
   }else if(r_a!=0. && i_a==0.){
	    if(r_a>0.)
	    	printf("%6.4lf",r_a);
	    else
		printf("(- %6.4lf)",-r_a);
	    pt_bin(i,L);	    
   }else if(i_a!=0. && r_a==0.){
	    if(i_a>0.)
		printf("i*%6.4lf",i_a);
	    else
		printf("(-i*%6.4lf)",-i_a);
	    pt_bin(i,L);
         }		
      }				// end if ||
  }				//end for
    printf("\n");
}				// end function
//***********************************************
void bin_k(double fase,int k){
int phim;
printf("%d.",phi_m(fase,0));
for(int j=1;j<k+1;j++){
    printf("%d",phi_m(fase,j));
      }
}
//******************************************
void reset_state(qubit_state &a){
int L=a.L();
int dim=EXP2(L);
a.put_to_zero();
a(0)=complex(1.,0.);
}
//**************************
double Pdelta(double delta,int m){
double p;
p=pow(sin(M_PI*delta),2.)/(pow(2.,2.*m)*pow(sin(M_PI*pow(2.,-1.*m)*delta),2.));
return p;
}
/*****************************************************************************************/
//				MAIN FUNCTION
/*****************************************************************************************/
int main(int argc,char **argv){

   int dim;
   int ip,ip2,jp,jp2;
   double fase,omega;
int d1;
double x1;
//
double AVPROB=0.;  
   time_t seconds00,seconds0,seconds1;
   char *filename;
   FILE *fp;
   FILE *fq;
   FILE *fg;
   FILE *gg;
   double prob=1.;
   double prob2=1.;
   double suc=0.;
   double suc2=0.;
int num_alphas=50;
int num=0; 		//number of measurements;
double error=0.05; 
double ganar=1.;
double sigma_sq=0.;
seconds00=time(NULL);
//
//assigning values to some of the parameters
nbr=1;
   sscanf(argv[1],"%lf",&epsilon);
//
if(argc<5){
initial_message();
}
//
   sscanf(argv[2],"%lf",&alpha); 
   sscanf(argv[3],"%d",&k);   		//number of precision bits
   sscanf(argv[4],"%d",&choice);	//type of noise
   sscanf(argv[5],"%d",&parec_flag);	//if parec (i.e. !=0), how many "parec blocks"
//
if(parec_flag>0){
 	parec_num=parec_flag;
	parec_flag=1;
	}else{
 	parec_num=1;
}

//
   seconds0=time(NULL);
   int stat_flag=choice;
   dim=EXP2(L);
   double phase,phase2;
   double dummy;
   complex e_iPIomega;


//for loop: alphas
for(int j=0;j<num_alphas;j++){

//in fact, generate alpha (0,1) randomly
  load_seed();
  alpha=rand_double();
  save_seed();
  init_eps();		// give values to epsilon
//
   e_iomega=complex(0.,0.);
   double i_omega=0.;
   int fi=0;

//

//
//*******************************************************
// **************************************************
   omega=0.;
   prob=1.;
   prob2=1.;
   suc=0.;
   suc2=0.;

//If there are static imperfections, "turn on" interaction.
  draw_stat();


fq=fopen("num.txt","w");
fp=fopen("prob.txt","w");

 Nk1=0.;Nk2=0.;
// k=m1;
 fi=0;omega=0.;
   gen_alpha();    	//generate angle truncated at k bits.
//
prob=1.;
prob2=1.;
suc=0.;
suc2=0.;
   printf("realiztion num.:\t %d\n",j);
//**********************************************************//
//		START P.E.A. LOOP 	********************//
// loop runs over all the k bits to compute
//
   load_seed();

error_estatico_parec();
for(int i=0;i<k;i++){
//reset state   
   reset_state(a_tot);
   reset_state(a_alt);
//
//compute phases:
   phase=2*M_PI*(EXP2(k-1-i)*alpha);
   phase2=2*M_PI*(EXP2(k-1-i)*(alpha2+(1./EXP2(k)-delt)));
   omega=((double)fi)/4.+omega/2.;
//
// generate randomness in the phases
   gen_rnd();
//
   i_omega=2*M_PI*omega*(1.+rnd2);
   e_ialpha=complex(cos(phase+2*M_PI*rnd3),sin(phase+2*M_PI*rnd3));
   e_ialpha2=complex(cos(phase2+2*M_PI*rnd3),sin(phase2+2*M_PI*rnd3));
   e_iomega=complex(cos((i_omega)/2.),sin((i_omega)/2.));  	//(because it's a rotation we use
//		  						// half the angle
//iterative  PEA step
//
   Hadamard(); 			//Hadamard gate
   error_estatico_parec(); 	//static imperfection + parec 
   control_phase(); 		//control phase gate
   error_estatico_parec();	//static imperfection + parec
   correct_z(); 		// feedback phase
   error_estatico_parec();	//static imperfection + parec
   Hadamard(); 			//Hadamard gate
   if(i<k-1){
     error_estatico_parec();
   }
//
//compute probabilities
   compute_probs();		
//
// fase=acos(2.*P00-1.)/DOSPI; --->antes....
   fi=phi_m(phase/DOSPI,1);
//
  if(fi==0){   	  	//
     suc=P00+P01;  	// takes into account the fact that probability *leaks* to states
     suc2= Q00+Q01;
  }else{		 // |01> and |11>...
     suc=P10+P11;   	//
     suc2=Q10+Q11;
  }
//
//

   int b1=0;
   int b2=0;
int fafa=1;
for(int j1=0;j1<fafa;j1++){
    b1+=a_tot.measure(1);
    b2+=a_alt.measure(1);
}
	fa1+=(1.*b1/(double)EXP2(k-i))/(1.*fafa);
 	fa2+=(1.*b2/(double)EXP2(k-i))/(1.*fafa);

   prob=prob*suc;
   prob2=prob2*suc2;

//
//
save_seed();
} // -----  fin del *for* para cada bit de la fase -------//
//

omega=2*(((double)fi)/4.+omega/2.);

//printf("prb: %lf \t prob2:%lf\t  prob+prob2:%lf\n",prob,prob2,prob+prob2);
AVPROB+=prob+prob2;
}//end of alpha For loop



fprintf(fp,"%18.17lf\t %d\t %18.17lf\n",epsilon,k,AVPROB/(1.*num_alphas));
printf("%18.17lf\t %d\t %18.17lf\n",epsilon,k,AVPROB/(1.*num_alphas));
fclose(fq);
save_seed();


fclose(fp);


return 0;
}
