/* "main" for the SHor algorithm with static imperfections used in 
 Phys. Rev. A 75, 052311 (2007). (peeled to basic, i.e. not including 
all the averaging loops and other things

There are some residual things, from previous versions, I didn't take out 
(sorry...)
*/
#define RANGE_CHECK 

#include "complex.h"
#include "random.h"
#include "quantum.h"
#include <time.h>
#include <math.h>
#include <iostream>
using namespace std;

#define GLOBAL_FILE "all_stat_fid.dat"

#define SAVE_SECONDS 60  // number of seconds between saving of quantum states
/***********************************/ 
inline double Max(double x,double y) { if(x>y) { return x;} else return y;};


void arr_init0(double *arr,int dim){
for(int i=0;i<dim;i++){
	arr[i]=0.0;
   }
return;
}

/***********************************/
int ipow_modN(int x, int y, int n){
    int i,k;
	k=1;
  for(i=0;i<y;i++){
      k=(k*x)%n;}
 return k;
}

int gcd(int a, int b)
{
if(a<0) a= (-a);
if(b<0) b= (-b);
    if (a == 0 &&b == 0)
        b = 1;
    else if (b == 0)
        b = a;
    else if (a != 0)
        while (a != b)
            if (a <b)
                b -= a;
            else
                a -= b;

    return b;
}
/***************************************************************/

int period(int x,int N){
  int r,f;
  
  if((f=gcd(x,N))>1){
    x/=f; N/=f;
  }
  r=1;
  f=x;
  while(f!=1){
    f=(x*f)%N;
    r++;
  }
  return r;
}
/* ########### FOLDING PART ############ */
/***************************************************************/
// refolding transformation function 
// to one peak at zero and shift of N/(2r)

int refolding_trans(int i,int r,int N){
  int N2,i1,j,i2;

  N2=(N/r+1)/2;
  i1=i+N2;
  j=(i1*r)/N;
  i2=(2*i1*r-2*j*N+r)/(2*r);
  return i2;
}
// Controlled modular exponentiator for shor, with controles on
// the first register of (nbqubits-nbr) qubits.
void Ushor(qubit_state &a, int x, int n, int nbr){
    int nz, l, xp;
    nz=a.L()-nbr;
    xp=x;
    for(l=0;l<nz;l++){
	a.Umod_control(xp,n,nbr,l);
	xp=(xp*xp)%n;
    }
}
//**********************************************************************
//
void Ushor_stat(qubit_state &a, int x, int n, int nbr,double eps,int ww,int del){
    int nz, l, xp,Lx;
    nz=a.L()-nbr;
    xp=x;
FILE *fq;
//
/// Uncomment line below for CORRELATED st. imperfection model
//a.draw_nbr_couplings(eps,eps,1.0,xp+del,nbr,ww); 
//
/// Uncomment line below for CORRELATED st. imperfection model on EVERY qubit
//a.draw_couplings(eps,eps,1.0,ww);
    for(l=0;l<nz;l++){
	a.Umod_control(xp,n,nbr,l);
/// Uncomment line below for GENERIC st. imperfection model		
	a.draw_nbr_couplings(eps,eps,1.0,xp+del,nbr,ww); 
// this depends if i want to make the realization "x" dependent...
//	a.draw_nbr_couplings(eps,eps,1.0,-1,nbr,ww);
	a.some_stat_error(1.0,1,nbr);
	xp=(xp*xp)%n;
    }
}
//*****************************************************//
double eta(double* arr1, int size){
double dif,dif1;
double arr3[size];
double arr2[size];
dif=0.0;
dif1=0.0;
for(int i=0;i<size;i++){
arr3[i]=1./((double)size);
if(i==size/2)
	arr2[i]=1.;
else
	arr2[i]=0.;
}
for (int i=0;i<size;i++){
dif +=fabs(arr1[i]-arr3[i]);
dif1+=fabs(arr2[i]-arr3[i]);
}
dif=dif/dif1;
return dif;
}
//*****************************************************//
//perform measurement.
//write prob dist into state3.txt
void med(qubit_state &a,int nbr,double eps,double *arr1,int &r0){

FILE *fq;
int dim,dim_r;
int count;

dim=EXP2(a.L()-nbr);
dim_r=EXP2(nbr);
int arr2[dim];
double norm=0.;
fq=fopen("state3.txt","w");
for(int i=0;i<dim;i++){
	double suma=0.;
	for(int j=0;j<dim_r;j++){
	    suma+=real_teil(a(i<<nbr|j)*conj(a(i<<nbr|j)));
	   }
	   arr1[i]=suma;
	   norm+=suma;
	fprintf(fq,"%9.7le %d %20.15le \n",eps,i,suma);   
	}
fprintf(fq,"\n");
fclose(fq);	
count=0;
//printf("\n norma=%6.5lf\n",norm);
int indx=0;
   if(arr1[0]>arr1[1]){
       arr2[count]=count;
       count++;       
   }
   for(int i=1;i<dim-1;i++){
	 if(arr1[i-1]<arr1[i]&&arr1[i+1]<arr1[i]){
	 arr2[count]=i;
	 count++; 
	 }
   }   
   if(arr1[dim-2]<arr1[dim-1]){
       arr2[count]=dim-1;
      count++;
   }
   r0=count;
double eps_dum=0.0000000001;   
   if(eps==0.){  
   	fq=fopen("r0.txt","w");
	fprintf(fq,"%d\n",r0);
	for(int i=0;i<r0;i++)
		fprintf(fq,"%d\n",arr2[i]);
	fclose(fq);
	fq=fopen("state_0.0.txt","w");
	for(int i=0;i<dim;i++)
	   	fprintf(fq,"%d \t %lf\n",i,arr1[i]);
	fclose(fq);
}
return ;
}
//******************************************
void stat(double *arr,int s,double eps){
FILE *fp;
double ev,var,i_ipr,ipr,center_max;
int smax;
ev=0.;
i_ipr=0.;
center_max=0.;
smax=0;
   for(int i=0;i<s;i++){ 
   	ev+=(i-s/2)*arr[i];
	i_ipr+=pow(arr[i],2.);
	if(arr[i]>center_max){
	   center_max=arr[i];
	   smax=i;
	}
   }
   for(int i=0;i<s;i++){
   	var+=arr[i]*pow(i-s/2-ev,2.);
   }
 fp=fopen("stat.txt","w");
 ipr=1./i_ipr;
 var=sqrt(var);
 fprintf(fp,"%15.13le %15.13le %15.13le %15.13le\n",eps,ev,var,ipr);
 fclose(fp);
 fp=fopen("mid.txt","w");
 fprintf(fp,"%15.13le\t %15.13le\t %15.13le \n",eps,arr[smax],arr[smax-1]+arr[smax]+arr[smax+1]);
 fclose(fp);
}
//****************************************
/*************************************/
int main(int argc,char **argv){
   int L,nbr,n,x,z,z1,k,dim_r,mark,r,Lx;
   int u,v,dummy,dim,del,s,kmax,ww,xp,r0;
   double epsilon;
   FILE *fp;
del=-10000; ///old paramenter...
sscanf(argv[1],"%d",&x);
sscanf(argv[2],"%d",&n);
sscanf(argv[3],"%lf",&epsilon);
sscanf(argv[4],"%d",&ww);

int fak=n;
  nbr=0;
  while(fak){
    nbr++;
    fak=fak>>1;
  }
  L=3*nbr;
int nl=L-nbr;
dim=EXP2(L-nbr);
printf("n=%d\t nbr=%d\t L=%d\n",n,nbr,L);
double meas[dim];
r0=period(x,n);
s=dim/r0+1;
 z=0;z1=1;
qubit_state a_tot(L,(z<<nbr|z1)); //|0>|1>
// SHOR:--------------------------------
for(int i=0;i<nl;i++)a_tot.A_gate(i+nbr); 	//hadamard on left nl qubits;   
   Ushor_stat(a_tot,x,n,nbr,epsilon,ww,del);	// controlled noisy mod. exp.
   a_tot.QFT_restricted(1,nbr,L); 		//QFT
   med(a_tot,nbr,epsilon,meas,r);  		//measurement
//-------------------------------------
printf("r0=%d\t s=%d\t r=%d\n",r0,s,r);
if(epsilon==0.0){
if(r%2!=0){
	printf(" Odd r, run Shor algorithm again\n");
	fehler(" using different x, please.");}
else{
    dummy=ipow_modN(x,r/2,n);
	if(dummy== -1) 
		fehler("bad x, run algorithm again, please. sorry!");
else
	    u=gcd(n,dummy-1);
 	    v=gcd(n,dummy+1);
}

printf("number to factorize: %d \n",n);
printf("u=(x^(r/2)-1) Mod(n)=%d\n",u);
printf("v=(x^(r/2)+1) Mod(n)=%d\n",v);
if(u==1||u==n)
	printf("no good, trivial factor... please, try again. sorry!\n");
if(u!=1&&u!=n)
     printf("\n %d is a nontrivial factor of %d !!!\n",u,n);
if(v!=1&& v!=n)
     printf("\n %d is a nontrivial factor of %d !!!\n",v,n);
printf("%d x %d = %d \n",u,v,u*v);
}
//
double buff[s+10];
int i2;
for(int i=0;i<s;i++)buff[i]=0;
for(int i=0;i<dim;i++){
    i2=refolding_trans(i,r0,dim);
    buff[i2]+=meas[i];
 }
//Print "clashed" probability dist into a data file
//IPR and Delta n^2 in the paper are extracted from buff.
fp=fopen("clashed.txt","w");
for(int i=0;i<s;i++)fprintf(fp,"%d %17.12le \n",i-s/2,buff[i]);
fclose(fp);
save_seed();
return 0;
}
