#include "complex.h"

// all operator functions are now inline in "complex.h"
/* 
complex operator+(complex a,complex b){
   return complex(a.re+b.re,a.im+b.im);
}

complex operator-(complex a,complex b){
	return complex(a.re-b.re,a.im-b.im);
}

complex operator*(complex a,complex b){
	return complex(a.re*b.re-a.im*b.im,a.re*b.im+a.im*b.re);
}
 
complex operator/(complex a,complex b){
	double nen;
	
	nen=b.re*b.re+b.im*b.im;
	return complex((a.re*b.re+a.im*b.im)/nen
		,(b.re*a.im-b.im*a.re)/nen);
}


int operator==(complex a,complex b){
	return ((a.re==b.re) && (a.im==b.im));
}
*/

complex csqrt(complex a){
        complex x;
        double d;
 
        if(a.im==0){
                if(a.re>=0){
                        x.re=sqrt(a.re); x.im=0;
                }else{
                        x.re=0; x.im=sqrt(-a.re);
                }
                return x;
        }
        d=sqrt(a.re*a.re+a.im*a.im);
        if(a.re>=0)
                x.re=sqrt((a.re+d)/2);
        else x.re=fabs(a.im)/sqrt(2*(d-a.re));
        x.im=a.im/(2*x.re);
        return x;
}


complex lese(void){
	complex a;
	
	printf("Realteil:      "); scanf("%lf",&a.re);
	printf("Imaginaerteil: "); scanf("%lf",&a.im);
	return a;
}

void print(complex a){
	printf("%24.15lf + i * %24.15lf\n",a.re,a.im);
}
