#include <stdio.h>
#include "random.h"

#define wurz3 1.73205080756887719318
#define max_zufall 2147483647
#define SEED_FILE ".random.seed"

/* Eigener Zufallszahlengenerator, nach RTOS-Pearl 
   mit zwei seed-Zahlen!!!! */

unsigned int konst_wert_1=217828199;
unsigned int konst_wert_2=314159269;
unsigned int seed_wert_1=111111;
unsigned int seed_wert_2=1111111;
unsigned int seed_old_1,seed_old_2;

void reset_random(){
  seed_wert_1=111111;
  seed_wert_2=1111111;
}

void save_seed(char *name){
  FILE *fp;

  if(name==NULL){
    fp=fopen(SEED_FILE,"w");
  }else{
    fp=fopen(name,"w");
  }
  fprintf(fp,"%12u %12u\n",seed_wert_1,seed_wert_2);
  fclose(fp);
}

int load_seed(char *name){
  FILE *fp;

  if(name==NULL){
    fp=fopen(SEED_FILE,"r");
  }else{
    fp=fopen(name,"r");
  }
  if(fp!=NULL){
    fscanf(fp,"%u%u",&seed_wert_1,&seed_wert_2);
    fclose(fp);
    return 1;
  }else{
    reset_random();
    return 0;
  }
}

void new_random(){
    printf("seed_1,  seed_2 ?  ");
    scanf("%u%u",&seed_wert_1,&seed_wert_2);
    printf("seed_1 = %12u ,  seed_2 = %12u\n",seed_wert_1,seed_wert_2);
    seed_old_1=seed_wert_1;
    seed_old_2=seed_wert_2;
}

int rand_eig(){
  unsigned int x;
  x=(konst_wert_1*seed_wert_2-konst_wert_2*seed_wert_1)%max_zufall;
  seed_wert_1=seed_wert_2;
  seed_wert_2=x;
  return x;
}

/* provides a random number between 0 and 1 */

double rand_double(void){
  int a;

  a=rand_eig();
  return (double)a/(double)max_zufall;
}

/* physikalische Rechteckverteilung */
/* Dieser Zufallszahlengenerator entspricht der 
   bei den Physikern ueblichen Konvention */

double zufall_recht_alt(double w){
  int a;

  a=rand_eig();
  return w*((double)a/(double)max_zufall-0.5);
}

/* Rechteckverteilung */

double zufall_recht(double w){
  int a;

  a=rand_eig();
/*  a=rand(); */
  return (w+w)*wurz3*((double)a/(double)max_zufall-0.5);
}

/* genaeherte Gaussverteilungen */

double zufall_gauss(double w,int wn){
  double x;
  int i,n;

  x=0; n=wn*wn;
  for(i=0;i<n;i++) x+=zufall_recht(w);
  return x/(double)wn;
}

