clear

%Defining single qubit operators
unity=[1 0;0 1];
x=[0 1;1 0];
y=[0 -i;i 0];
z=[1 0;0 -1];
plus=[0 1;0 0];
minus=[0 0; 1 0];
H=[1 1;1 -1]/sqrt(2);

%Defining two-qubit operators
zz=kron(z,z);
xx=kron(x,x);
z1=kron(z,unity);
z2=kron(unity,z);
x1=kron(x,unity);
x2=kron(unity,x);
y1=kron(y,unity);
y2=kron(unity,y);
p1m2=kron(plus,minus);
m1p2=kron(minus,plus);

H1=kron(H,unity);
H2=kron(unity,H);

%Initialize random generator
rand('state',sum(100*clock))

repetitionsnumber=200000;%Number of different angles, to get statistics

%Accuracy, i.e. the number of binary digits to extract
m=20;

tic

%Initialize error counters
errors=zeros(1,m+1);
toterrors=zeros(1,m+1);


for rep=1:repetitionsnumber
    fi=rand;%Choose the angle with an even distribution between 0 and 2pi
    alpha=2*pi*fi;
    omega=0;%Initialize the kick-back angle to 0

    %Loop through the m iterations
    for k=m-1:-1:0
        itett=0;
        %The gates of the iteration are constructed and multiplied
        angle=2*pi*omega;
        Rz1om=cos(angle/2)*eye(4)+i*sin(angle/2)*z1;
        angle=mod(2^k*alpha,2*pi);
        ZZom=cos(angle/2)*eye(4)+i*sin(angle/2)*zz;
        angle=pi/2;
        firstRx1Pi2=cos(angle/2)*eye(4)+i*sin(angle/2)*x1;
        angle=pi/2;
        secondRx1Pi2=cos(angle/2)*eye(4)+i*sin(angle/2)*x1;
        angle=pi;
        Rx1Pi=cos(angle/2)*eye(4)+i*sin(angle/2)*x1;
        Algorithm=secondRx1Pi2*Rz1om*Rx1Pi*ZZom*firstRx1Pi2;

        %Measurement
        input=[1 0 0 0]';
        prob=abs(Algorithm*input).^2 ;
        prob1qb1=prob(3)+prob(4);
        itett=0;
        if (rand < prob1qb1)
            itett=1; %Measured 1 (else 0)
        end

        omega=omega/2;
        if (itett > 0)
            omega=omega+1/4; %Measured 1 (else 0)
        end
    end

    %Check for erroneous bits in the answer
    answer=2*omega;
    err=min([abs(fi-answer) abs(1+fi-answer) abs(fi-answer-1)]);
    errbits=find(dec2bin(uint64(err*2^m),m+1)==49);
    if length(errbits) > 0
        toterrors(errbits)=toterrors(errbits)+1;
        maxerrbit=min(errbits);
        errors(maxerrbit)=errors(maxerrbit)+1;
    end
end

toc
%Calculate the average bitwise error probability
errprob=errors/repetitionsnumber
