/* *********************************************************************
   | The Q language - A C++ extension for programming quantum machines |
   | Copyright (C) 2000 2001 2002 2003 Stefano Bettelli                |
   | <bettelli@irsamc.ups-tlse.fr>                                     |
   | See the COPYING and LICENSE files for license terms.              |
   ********************************************************************* */

#include <qop_slice_basegate.h>                  // the class declaration

/* *********************************************************************
   | These global constant objects will be referenced by all the time  |
   | slices for getting information about their base gates. Different  |
   | gate sets should register different base gates.                   |
   | ----------------------------------------------------------------- |
   | This is the set which I proposed in cs.PL/0103009: Hadamard gates,|
   | z rotations and controlled z rotations (plus swap gates, which    |
   | are however implemented in the classical machine). z rotations    |
   | and their controlled counterpart need an additional parameter,    |
   | which is an angle in [0, 2*M_PI[.                                 |
   |                                                                   |
   | Stefano Bettelli, IRSAMC, UPS, Toulouse,      10 Nov 2002         |
   ********************************************************************* */

extern const Qop_slice_basegate BASEGATE_HADAMARD;
extern const Qop_slice_basegate BASEGATE_PHASE;
extern const Qop_slice_basegate BASEGATE_COND_PHASE;
extern const Qop_slice_basegate BASEGATE_SWAP;

//;;; Local Variables: ***
//;;; mode:C++ ***
//;;; End: ***
