/* *********************************************************************
   | The Q language - A C++ extension for programming quantum machines |
   | Copyright (C) 2000 2001 2002 2003 Stefano Bettelli                |
   | <bettelli@irsamc.ups-tlse.fr>                                     |
   | See the COPYING and LICENSE files for license terms.              |
   ********************************************************************* */
#include <iostream>
#include <quantum_computing.h>
#include <quantum_library.h>

int main(void) {
  try {

    int qubits = 5;
    int power  = 4;
    double f   = +9.123456789012345;
    Qop expw = expower(qubits, power, f);
    expw.print_statistics(std::cout);
    Qreg reg(qubits);
    for (int i=0; i<100; ++i) expw(reg);
    std::cout << "      Result\t" << reg.measure() << std::endl;
    goto end;
    
    /* This example reproduces the address manager status which
       is shown in figure 2, pag.5 of the reference article. */
    Qreg A(36);                        // A is simple
    Qreg B(30);                        // B is simple
    Qreg C = B(0,6).swap() &           // a complicated expr. for C
      (Qreg(A) -= 12).swap();          // unnecessary use of -=
    Qreg D = B(12,18) & Qreg(18);      // create D more simply
    Qreg E = C(0, 24) & D & Qreg(6);   // E is disconnected
    /* Show the address manager status and the register content. */
    std::cout << "============================\n"
	      << get_quantum_interface()
	      << "\nRegister A: " << A
	      << "\nRegister B: " << B
	      << "\nRegister C: " << C
	      << "\nRegister D: " << D
	      << "\nRegister E: " << E
	      << "\n============================\n";
    /* This example reproduces the quantum circuit for summing
       three numbers, sec.4.1, pag.12 in the reference article. */
    int size = 4;
    /* prepare the sequence of conditional rotations */
    Qop rot;
    for (int i=0; i<size; ++i)
      rot << QCondPhase(size-i, i+1).offset(i);
    /* prepare a translated Fourier transform */
    Qop tras = (QFourier(size) & QSwap(size)).offset(size);
    /* compose the two argument adder */
    Qop add = tras & rot & ! tras;
    /* offset the 2-adder down, split another 2-adder,
       compose the two 2-adders into one 3-adder */
    Qop add3 = (add >> size) & add(size, size, Qop::SPLIT);
    /* Show the quantum operator structure. */
    std::cout << "============================\n"
	      << add3 << std::endl
	      << "============================\n";
    /* "Run" the computation on first 12 qubits of the E register. */
    add3(E(18,12));
  } catch_qexception;
 end:
  return 0;
}
