/* *********************************************************************
   | The Q language - A C++ extension for programming quantum machines |
   | Copyright (C) 2000 2001 2002 2003 Stefano Bettelli                |
   | <bettelli@irsamc.ups-tlse.fr>                                     |
   | See the COPYING and LICENSE files for license terms.              |
   ********************************************************************* */
#include "qmanager_base.h"                        // class declaration

/* *********************************************************************
   | This method increments the usage counts for a list of segments.   |
   | This is done by iterating through the list and incrementing the   |
   | corresponding usage counts for each segment separately.           |
   |                                                                   |
   | Stefano Bettelli, INFN and Trento University, 02 Feb 2001         |
   ********************************************************************* */
void Qaddress_manager_base::checkin_qubits(const Qubit_list &a_list) {
  /* iterate through the list and take care of each register segment. 
     The dirty job is done by checkin_qubits(Qubit_segment &). */
  for (Qubit_list::const_iterator a_segment = a_list.begin();
       a_segment != a_list.end(); ++a_segment)
    checkin_qubits(*a_segment);
}

/* *********************************************************************
   | This method "deallocates" the logical qubits referenced inside    |
   | the list. This method must iterate through the user list and      |
   | decrease the usage counts for each segment separately.            |
   |                                                                   |
   | Stefano Bettelli, INFN and Trento University, 26 Jan 2001         |
   ********************************************************************* */
void Qaddress_manager_base::checkout_qubits(const Qubit_list &a_list) {
  /* iterate through the list and take care of each register segment.
     The dirty job is done by checkout_qubits(Qubit_segment &). */
  for (Qubit_list::const_iterator a_segment = a_list.begin();
       a_segment != a_list.end(); ++a_segment)
    checkout_qubits(*a_segment);
}

/* *********************************************************************
   | This output function uses a pointer to Qaddress_manager_base to   |
   | printout the details of the most derived class (since this class  |
   | is only an interface with no private data).                       |   
   |                                                                   |
   | Stefano Bettelli, IRSAMC, UPS, Toulouse,      18 Jul 2002         |
   ********************************************************************* */
std::ostream &operator<<(std::ostream &os,
			 const Qaddress_manager_base *the_manager) {
  return the_manager->output_details(os);
}

//;;; Local Variables: ***
//;;; mode:C++ ***
//;;; End: ***
