/* *********************************************************************
   | The Q language - A C++ extension for programming quantum machines |
   | Copyright (C) 2000 2001 2002 2003 Stefano Bettelli                |
   | <bettelli@irsamc.ups-tlse.fr>                                     |
   | See the COPYING and LICENSE files for license terms.              |
   ********************************************************************* */
#ifndef __SPECIFIC_CTOR_ROUTINES_FOR_QOPS_
#define __SPECIFIC_CTOR_ROUTINES_FOR_QOPS_

#include "qop_slicelist.h"                    // for lists of Qop_slices

/* *********************************************************************
   | This macro will expand "name" into a class called "name_slices"   |
   | which inherits from Qop_slicelist. The only method which is then  |
   | specified is the constructor, whose argument list must be supplied|
   | (surrounded by parenthesis) as second argument to the macro.      |
   | (30 Apr 2002) S.Bettelli, moved operator~ directly in base class. |
   |                                                                   |
   | Stefano Bettelli, INFN and Trento University, 03 Oct 2001         |
   | Stefano Bettelli, IRSAMC, UPS, Toulouse,      30 Apr 2002         |
   ********************************************************************* */
#define slices(name, args)                       \
  class name ## _slices : public Qop_slicelist { \
  public : name ## _slices args ; }

/* builder for a NOT */
slices(QNot,           (const Qubit_list &the_list));

/* builder for a CNOT */
slices(QCnot,          (const Qubit_list &the_controls,
			const Qubit_list &the_targets));

/* builder for a Fourier transform */
slices(QFourier,       (const Qubit_list &the_list));

/* builder for a controlled Hadamard gate */
slices(QCondHadamard,  (const Qubit_list &the_controls,
			const Qubit_list &the_targets));

/* builder for a doubly controlled phase shift */
slices(QCondCondPhase, (const Qubit_list &the_controls_1,
			const Qubit_list &the_controls_2,
			const Qubit_list &the_targets,
			::quantum_phase_power_type    the_power,
			::quantum_phase_floating_type the_fraction));

/* builder for a Toffoli gate (doubly controlled X) */
slices(Toffoli,        (const Qubit_list &the_controls_1,
			const Qubit_list &the_controls_2,
			const Qubit_list &the_targets));

/* builder for a controlled swap gate */
slices(QCondSwap,      (const Qubit_list &the_controls,
			const Qubit_list &the_swaplist_1,
			const Qubit_list &the_swaplist_2));

#endif  // __SPECIFIC_CTOR_ROUTINES_FOR_QOPS_
//;;; Local Variables: ***
//;;; mode:C++ ***
//;;; End: ***

