/* *********************************************************************
   | The Q language - A C++ extension for programming quantum machines |
   | Copyright (C) 2000 2001 2002 2003 Stefano Bettelli                |
   | <bettelli@irsamc.ups-tlse.fr>                                     |
   | See the COPYING and LICENSE files for license terms.              |
   ********************************************************************* */
#ifndef __QUANTUM_OPERATION_CODES_
#define __QUANTUM_OPERATION_CODES_

/* *********************************************************************
   | A list of codes for quantum operations. The values must be con-   |
   | sistent with the quantum_operation_code_type. Moreover, we should |
   | choose an encoding scheme which is easy to decode. Currently the  |
   | first 8 bits are used to encode the operation type or family and  |
   | the following 8 bits are used to completely specify the code.     |
   | Therefore we need at least 16 bits.                               |
   |                                                                   |
   | Stefano Bettelli, INFN and Trento University, 25 May 2001         |
   ********************************************************************* */

/* reserve 8 bits each for the operation type and code */
#define OPTYPE_SIZE 8
#define OPCODE_SIZE 8

/* prepare two mask for extracting the relevant bits */
#define OPTYPE_MASK   ( 0xff << OPCODE_SIZE )
#define OPCODE_MASK  (( 0x01 << OPCODE_SIZE ) - 1)

/* prepare two macro for extracting the relevant bits */
#define GET_OPTYPE(val) ( (val) & OPTYPE_MASK )
#define GET_OPCODE(val) ( (val) & OPCODE_MASK )

/* operation types */
#define OPTYPE_NOTUNI ( 0x01 << OPCODE_SIZE )  // non unitary interactions
#define OPTYPE_SINGLE ( 0x02 << OPCODE_SIZE )  // arity-1 operations
#define OPTYPE_DOUBLE ( 0x04 << OPCODE_SIZE )  // arity-2 operations
#define OPTYPE_MACRO  ( 0x08 << OPCODE_SIZE )  // macro operations
#define OPTYPE_DEVICE ( 0x10 << OPCODE_SIZE )  // interac. with quantum device

/* operation codes */
#define OPCODE_INITIALISATION        ( OPTYPE_NOTUNI | 0x01 )
#define OPCODE_MEASURE               ( OPTYPE_NOTUNI | 0x02 )
#define OPCODE_HADAMARD              ( OPTYPE_SINGLE | 0x01 )
#define OPCODE_PHASE                 ( OPTYPE_SINGLE | 0x02 )
#define OPCODE_COND_PHASE            ( OPTYPE_DOUBLE | 0x01 )
#define OPCODE_SWAP                  ( OPTYPE_DOUBLE | 0x02 )  // not sent!
#define OPCODE_LOCATE                ( OPTYPE_DEVICE | 0x01 )

#endif  // __QUANTUM_OPERATION_CODES_
//;;; Local Variables: ***
//;;; mode:C++ ***
//;;; End: ***
